/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.thoughtworks.xstream.XStream;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.azure.AzureBlobStoreConfigProvider;
import org.geowebcache.azure.AzureBlobStoreInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AzureBlobStoreConfigProviderTest {
    @Before
    public void setUp() throws Exception {
        System.setProperty("CONTAINER", "MYCONTAINER");
        System.setProperty("MYKEY", "99942777gfa+");
        System.setProperty("CONNECTIONS", "30");
        System.setProperty("ENABLED", "true");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("appContextTestAzure.xml");
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext((ApplicationContext)context);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("CONTAINER");
        System.clearProperty("MYKEY");
        System.clearProperty("CONNECTIONS");
        System.clearProperty("ENABLED");
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
    }

    @Test
    public void testValuesFromEnvironment() {
        AzureBlobStoreConfigProvider provider = new AzureBlobStoreConfigProvider();
        XStream stream = new XStream();
        stream = provider.getConfiguredXStream(stream);
        Object config = stream.fromXML(this.getClass().getResourceAsStream("blobstore.xml"));
        Assert.assertTrue((boolean)(config instanceof AzureBlobStoreInfo));
        AzureBlobStoreInfo abConfig = (AzureBlobStoreInfo)config;
        Assert.assertEquals((Object)"${CONTAINER}", (Object)abConfig.getContainer());
        Assert.assertEquals((Object)"myname", (Object)abConfig.getAccountName());
        Assert.assertEquals((Object)"${MYKEY}", (Object)abConfig.getAccountKey());
        Assert.assertEquals((Object)"30", (Object)abConfig.getMaxConnections());
        Assert.assertTrue((boolean)abConfig.isEnabled());
    }
}

