/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.azure.AzureBlobStoreInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AzureBlobStoreDataTest {
    @Before
    public void setUp() throws Exception {
        System.setProperty("CONTAINER", "MYCONTAINER");
        System.setProperty("ACCOUNT_NAME", "MYNAME");
        System.setProperty("ACCOUNT_KEY", "MYKEY");
        System.setProperty("CONNECTIONS", "30");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("appContextTestAzure.xml");
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext((ApplicationContext)context);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("CONTAINER");
        System.clearProperty("CONNECTIONS");
        System.clearProperty("ACCOUNT_NAME");
        System.clearProperty("ACCOUNT_KEY");
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
    }

    @Test
    public void testEnvironmentProperties() {
        GeoWebCacheEnvironment typedEnvironment = (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class);
        AzureBlobStoreInfo storeInfo = new AzureBlobStoreInfo("info1");
        storeInfo.setContainer("${CONTAINER}");
        storeInfo.setAccountName("${ACCOUNT_NAME}");
        storeInfo.setAccountKey("${ACCOUNT_KEY}");
        storeInfo.setMaxConnections("${CONNECTIONS}");
        storeInfo.setEnabled(true);
        AzureBlobStoreData storeData = new AzureBlobStoreData(storeInfo, typedEnvironment);
        Assert.assertEquals((Object)30, (Object)storeData.getMaxConnections());
        Assert.assertEquals((Object)"MYCONTAINER", (Object)storeData.getContainer());
        Assert.assertEquals((Object)"MYNAME", (Object)storeData.getAccountName());
        Assert.assertEquals((Object)"MYKEY", (Object)storeData.getAccountKey());
    }
}

