/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.geowebcache.azure.AzureBlobStore;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.azure.PropertiesLoader;
import org.geowebcache.azure.TemporaryAzureFolder;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.NoOpLockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreSuitabilityTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.runner.RunWith;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.http.HttpStatus;

@RunWith(value=MyTheories.class)
public class AzureBlobStoreSuitabilityTest
extends BlobStoreSuitabilityTest {
    public PropertiesLoader testConfigLoader = new PropertiesLoader();
    @Rule
    public TemporaryAzureFolder tempFolder = new TemporaryAzureFolder(this.testConfigLoader.getProperties());
    @DataPoints
    public static String[][] persistenceLocations = new String[][]{new String[0], {"metadata.properties"}, {"something"}, {"something", "metadata.properties"}, {"something/metadata.properties"}};
    TileLayerDispatcher tld;
    LockProvider locks;

    @Before
    public void setup() throws Exception {
        this.tld = (TileLayerDispatcher)EasyMock.createMock((String)"tld", TileLayerDispatcher.class);
        this.locks = new NoOpLockProvider();
        EasyMock.replay((Object[])new Object[]{this.tld});
    }

    protected Matcher<Object> existing() {
        return Matchers.hasItemInArray((Matcher)Matchers.equalTo((Object)"metadata.properties"));
    }

    protected Matcher<Object> empty() {
        return Matchers.emptyArray();
    }

    public BlobStore create(Object dir) throws Exception {
        AzureBlobStoreData info = this.tempFolder.getConfig();
        for (String path : (String[])dir) {
            String fullPath = info.getPrefix() + "/" + path;
            ByteBuffer byteBuffer = ByteBuffer.wrap("testAbc".getBytes());
            int statusCode = ((BlockBlobUploadResponse)this.tempFolder.getClient().getBlockBlobURL(fullPath).upload(Flowable.just((Object)byteBuffer), (long)byteBuffer.limit()).blockingGet()).statusCode();
            Assert.assertTrue((boolean)HttpStatus.valueOf((int)statusCode).is2xxSuccessful());
        }
        return new AzureBlobStore(info, this.tld, this.locks);
    }

    public static class MyTheories
    extends Theories {
        public MyTheories(Class<?> klass) throws InitializationError {
            super(klass);
        }

        public Statement methodBlock(FrameworkMethod method) {
            if (new PropertiesLoader().getProperties().containsKey("container")) {
                return super.methodBlock(method);
            }
            return new Statement(){

                public void evaluate() {
                    Assume.assumeFalse((String)"Azure unavailable", (boolean)true);
                }
            };
        }
    }
}

