/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class PropertiesLoader {
    private static Logger log = Logging.getLogger((String)PropertiesLoader.class.getName());
    private Properties properties = new Properties();

    public PropertiesLoader() {
        String home = System.getProperty("user.home");
        File configFile = new File(home, ".gwc_azure_tests.properties");
        log.info("Loading Azure tests config. File must have keys 'container', 'accountName', and 'accountKey'");
        if (configFile.exists()) {
            try (FileInputStream in = new FileInputStream(configFile);){
                this.properties.load(in);
                Preconditions.checkArgument((null != this.properties.getProperty("container") ? 1 : 0) != 0, (Object)("container not provided in config file " + configFile.getAbsolutePath()));
                Preconditions.checkArgument((null != this.properties.getProperty("accountName") ? 1 : 0) != 0, (Object)("accountName not provided in config file " + configFile.getAbsolutePath()));
                Preconditions.checkArgument((null != this.properties.getProperty("accountKey") ? 1 : 0) != 0, (Object)("accountKey not provided in config file " + configFile.getAbsolutePath()));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error loading Azure tests config: " + configFile.getAbsolutePath(), e);
            }
        } else {
            log.warning("Azure storage config file not found. Azure Azure tests will be ignored. " + configFile.getAbsolutePath());
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

