/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.base.Preconditions;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.models.BlobDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobItem;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.azure.AzureClient;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.springframework.http.HttpStatus;

public class TemporaryAzureFolder
extends ExternalResource {
    private Properties properties;
    private String container;
    private String accountName;
    private String accountKey;
    private String temporaryPrefix;
    private AzureClient client;

    public TemporaryAzureFolder(Properties properties) {
        this.properties = properties;
        this.container = properties.getProperty("container");
        this.accountName = properties.getProperty("accountName");
        this.accountKey = properties.getProperty("accountKey");
    }

    protected void before() throws Throwable {
        if (!this.isConfigured()) {
            return;
        }
        this.temporaryPrefix = "tmp_" + UUID.randomUUID().toString().replace("-", "");
        this.client = new AzureClient(this.getConfig());
    }

    protected void after() {
        if (!this.isConfigured()) {
            return;
        }
        try {
            this.delete();
        }
        finally {
            this.temporaryPrefix = null;
            this.client.close();
        }
    }

    public AzureClient getClient() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"client not configured.");
        return this.client;
    }

    public AzureBlobStoreData getConfig() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"Azure connection not configured.");
        AzureBlobStoreData config = new AzureBlobStoreData();
        config.setContainer(this.container);
        config.setAccountName(this.accountName);
        config.setAccountKey(this.accountKey);
        config.setPrefix(this.temporaryPrefix);
        if (this.properties.getProperty("serviceURL") != null) {
            config.setServiceURL(this.properties.getProperty("serviceURL"));
        }
        if (this.properties.getProperty("maxConnections") != null) {
            config.setMaxConnections(Integer.valueOf(this.properties.getProperty("maxConnections")));
        }
        if (this.properties.getProperty("useHTTPS") != null) {
            config.setUseHTTPS(Boolean.valueOf(this.properties.getProperty("useHTTPS")));
        }
        if (this.properties.getProperty("proxyHost") != null) {
            config.setProxyHost(this.properties.getProperty("proxyHost"));
        }
        if (this.properties.getProperty("proxyPort") != null) {
            config.setProxyPort(Integer.valueOf(this.properties.getProperty("proxyPort")));
        }
        if (this.properties.getProperty("proxyUsername") != null) {
            config.setProxyUsername(this.properties.getProperty("proxyUsername"));
        }
        if (this.properties.getProperty("proxyPassword") != null) {
            config.setProxyPassword(this.properties.getProperty("proxyPassword"));
        }
        return config;
    }

    public void delete() {
        Preconditions.checkState((boolean)this.isConfigured(), (Object)"client not configured.");
        if (this.temporaryPrefix == null) {
            return;
        }
        List blobs = this.client.listBlobs(this.temporaryPrefix, Integer.valueOf(Integer.MAX_VALUE));
        for (BlobItem blob : blobs) {
            BlockBlobURL blockBlobURL = this.client.getBlockBlobURL(blob.name());
            int status = ((BlobDeleteResponse)blockBlobURL.delete().blockingGet()).statusCode();
            Assert.assertTrue((String)("Expected success but got " + status + " while deleting " + blob.name()), (boolean)HttpStatus.valueOf((int)status).is2xxSuccessful());
        }
    }

    public boolean isConfigured() {
        return this.container != null && this.accountName != null && this.accountKey != null;
    }
}

