/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.DownloadResponse;
import com.microsoft.azure.storage.blob.models.BlobDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlobItem;
import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import com.microsoft.rest.v2.RestException;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.reactivex.Flowable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.azure.AzureClient;
import org.geowebcache.azure.DeleteManager;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.util.TMSKeyBuilder;
import org.springframework.http.HttpStatus;

public class AzureBlobStore
implements BlobStore {
    static Logger log = Logging.getLogger((String)AzureBlobStore.class.getName());
    private final TMSKeyBuilder keyBuilder;
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();
    private final AzureClient client;
    private DeleteManager deleteManager;
    private volatile boolean shutDown = false;

    public AzureBlobStore(AzureBlobStoreData configuration, TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        this.client = new AzureClient(configuration);
        String prefix = Optional.ofNullable(configuration.getPrefix()).orElse("");
        this.keyBuilder = new TMSKeyBuilder(prefix, layers);
        boolean emptyFolder = this.client.listBlobs(prefix, 1).isEmpty();
        boolean existingMetadata = !this.client.listBlobs(this.keyBuilder.storeMetadata(), 1).isEmpty();
        CompositeBlobStore.checkSuitability((String)configuration.getLocation(), (boolean)existingMetadata, (boolean)emptyFolder);
        this.client.putProperties(this.keyBuilder.storeMetadata(), new Properties());
        this.deleteManager = new DeleteManager(this.client, lockProvider, this.keyBuilder, configuration.getMaxConnections());
        this.deleteManager.issuePendingBulkDeletes();
    }

    public boolean delete(String layerName) throws StorageException {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        String metadataKey = this.keyBuilder.layerMetadata(layerName);
        String layerPrefix = this.keyBuilder.forLayer(layerName);
        try {
            BlockBlobURL metadata = this.client.getBlockBlobURL(metadataKey);
            int statusCode = ((BlobDeleteResponse)metadata.delete().blockingGet()).statusCode();
            if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
                return false;
            }
        }
        catch (RestException e) {
            return false;
        }
        boolean layerExists = this.deleteManager.scheduleAsyncDelete(layerPrefix);
        if (layerExists) {
            this.listeners.sendLayerDeleted(layerName);
        }
        return layerExists;
    }

    public boolean deleteByParametersId(String layerName, String parametersId) throws StorageException {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        Preconditions.checkNotNull((Object)parametersId, (Object)"parametersId");
        boolean prefixExists = this.keyBuilder.forParameters(layerName, parametersId).stream().map(prefix -> {
            try {
                return this.deleteManager.scheduleAsyncDelete((String)prefix);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }).reduce(Boolean::logicalOr).orElse(false);
        if (prefixExists) {
            this.listeners.sendParametersDeleted(layerName, parametersId);
        }
        return prefixExists;
    }

    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName");
        Preconditions.checkNotNull((Object)gridSetId, (Object)"gridSetId");
        String gridsetPrefix = this.keyBuilder.forGridset(layerName, gridSetId);
        boolean prefixExists = this.deleteManager.scheduleAsyncDelete(gridsetPrefix);
        if (prefixExists) {
            this.listeners.sendGridSubsetDeleted(layerName, gridSetId);
        }
        return prefixExists;
    }

    public boolean delete(TileObject obj) throws StorageException {
        String key = this.keyBuilder.forTile(obj);
        BlockBlobURL blob = this.client.getBlockBlobURL(key);
        if (this.listeners.isEmpty()) {
            try {
                int statusCode = ((BlobDeleteResponse)blob.delete().blockingGet()).statusCode();
                return HttpStatus.valueOf((int)statusCode).is2xxSuccessful();
            }
            catch (RestException e) {
                return false;
            }
        }
        try {
            BlobGetPropertiesResponse properties = (BlobGetPropertiesResponse)blob.getProperties().blockingGet();
            Long oldSize = properties.headers().contentLength();
            int statusCode = ((BlobDeleteResponse)blob.delete().blockingGet()).statusCode();
            if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
                return false;
            }
            if (oldSize != null) {
                obj.setBlobSize(oldSize.intValue());
            }
        }
        catch (RestException e) {
            if (e.response().statusCode() != 404) {
                throw new StorageException("Failed to delete tile ", (Throwable)e);
            }
            return false;
        }
        this.listeners.sendTileDeleted(obj);
        return true;
    }

    public boolean delete(final TileRange tileRange) throws StorageException {
        String coordsPrefix = this.keyBuilder.coordinatesPrefix(tileRange, true);
        if (this.client.listBlobs(coordsPrefix, 1).isEmpty()) {
            return false;
        }
        AbstractIterator<long[]> tileLocations = new AbstractIterator<long[]>(){
            private TileRangeIterator trIter;
            {
                this.trIter = new TileRangeIterator(tileRange, new int[]{1, 1});
            }

            protected long[] computeNext() {
                long[] gridLoc = this.trIter.nextMetaGridLocation(new long[3]);
                return gridLoc == null ? (long[])this.endOfData() : gridLoc;
            }
        };
        if (this.listeners.isEmpty()) {
            Iterator keysIterator = Iterators.transform((Iterator)tileLocations, tl -> this.keyBuilder.forLocation(coordsPrefix, tl, tileRange.getMimeType()));
            UnmodifiableIterator partition = Iterators.partition((Iterator)keysIterator, (int)1000);
            while (partition.hasNext() && !this.shutDown) {
                List locations = (List)partition.next();
                this.deleteManager.deleteParallel(locations);
            }
        } else {
            String layerName = tileRange.getLayerName();
            String gridSetId = tileRange.getGridSetId();
            String format = tileRange.getMimeType().getFormat();
            Map parameters = tileRange.getParameters();
            Iterator tilesIterator = Iterators.transform((Iterator)tileLocations, xyz -> {
                TileObject tile = TileObject.createQueryTileObject((String)layerName, (long[])xyz, (String)gridSetId, (String)format, (Map)parameters);
                tile.setParametersId(tileRange.getParametersId());
                return () -> this.delete(tile);
            });
            UnmodifiableIterator partition = Iterators.partition((Iterator)tilesIterator, (int)1000);
            while (partition.hasNext() && !this.shutDown) {
                this.deleteManager.executeParallel((List)partition.next());
            }
        }
        return true;
    }

    public boolean get(TileObject obj) throws StorageException {
        String key = this.keyBuilder.forTile(obj);
        BlockBlobURL blob = this.client.getBlockBlobURL(key);
        try {
            DownloadResponse response = (DownloadResponse)blob.download().blockingGet();
            ByteBuffer buffer = (ByteBuffer)FlowableUtil.collectBytesInBuffer((Flowable)response.body(null)).blockingGet();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            obj.setBlobSize(bytes.length);
            obj.setBlob((Resource)new ByteArrayResource(bytes));
            obj.setCreated(response.headers().lastModified().toEpochSecond() * 1000L);
        }
        catch (RestException e) {
            if (e.response().statusCode() == 404) {
                return false;
            }
            throw new StorageException("Error getting " + key, (Throwable)e);
        }
        return true;
    }

    public void put(TileObject obj) throws StorageException {
        boolean existed;
        Long oldSize;
        BlockBlobURL blobURL;
        String key;
        Resource blob;
        block15: {
            blob = obj.getBlob();
            Preconditions.checkNotNull((Object)blob);
            Preconditions.checkNotNull((Object)obj.getBlobFormat());
            key = this.keyBuilder.forTile(obj);
            blobURL = this.client.getBlockBlobURL(key);
            oldSize = null;
            existed = false;
            if (!this.listeners.isEmpty()) {
                try {
                    BlobGetPropertiesResponse properties = (BlobGetPropertiesResponse)blobURL.getProperties().blockingGet();
                    oldSize = properties.headers().contentLength();
                    existed = true;
                }
                catch (RestException e) {
                    if (e.response().statusCode() == HttpStatus.NOT_FOUND.value()) break block15;
                    throw new StorageException("Failed to check if the container exists", (Throwable)e);
                }
            }
        }
        try (InputStream is = blob.getInputStream();){
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            String mimeType = MimeType.createFromFormat((String)obj.getBlobFormat()).getMimeType();
            BlobHTTPHeaders headers = new BlobHTTPHeaders().withBlobContentType(mimeType);
            int status = ((BlockBlobUploadResponse)blobURL.upload(Flowable.just((Object)buffer), (long)bytes.length, headers, null, null, null).blockingGet()).statusCode();
            if (!HttpStatus.valueOf((int)status).is2xxSuccessful()) {
                throw new StorageException("Failed to upload tile to Azure on container " + this.client.getContainerName() + " and key " + key + " got HTTP  status " + status);
            }
        }
        catch (RestException | IOException | MimeException e) {
            throw new StorageException("Failed to upload tile to Azure on container " + this.client.getContainerName() + " and key " + key, e);
        }
        this.putParametersMetadata(obj.getLayerName(), obj.getParametersId(), obj.getParameters());
        if (!this.listeners.isEmpty()) {
            if (existed) {
                this.listeners.sendTileUpdated(obj, oldSize.longValue());
            } else {
                this.listeners.sendTileStored(obj);
            }
        }
    }

    private void putParametersMetadata(String layerName, String parametersId, Map<String, String> parameters) {
        assert (Objects.isNull(parametersId) == Objects.isNull(parameters));
        if (Objects.isNull(parametersId)) {
            return;
        }
        Properties properties = new Properties();
        parameters.forEach(properties::setProperty);
        String resourceKey = this.keyBuilder.parametersMetadata(layerName, parametersId);
        try {
            this.client.putProperties(resourceKey, properties);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() throws StorageException {
        throw new UnsupportedOperationException("clear() should not be called");
    }

    public void destroy() {
        this.shutDown = true;
        if (this.client != null) {
            this.client.close();
        }
        if (this.deleteManager != null) {
            this.deleteManager.close();
        }
    }

    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean removeListener(BlobStoreListener listener) {
        return this.listeners.removeListener(listener);
    }

    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        log.fine("No need to rename layers, AzureBlobStore uses layer id as key root");
        if (this.client.listBlobs(oldLayerName, 1).size() > 0) {
            this.listeners.sendLayerRenamed(oldLayerName, newLayerName);
        }
        return true;
    }

    @Nullable
    public String getLayerMetadata(String layerName, String key) {
        Properties properties = this.getLayerMetadata(layerName);
        String value = properties.getProperty(key);
        return value;
    }

    public void putLayerMetadata(String layerName, String key, String value) {
        Properties properties = this.getLayerMetadata(layerName);
        properties.setProperty(key, value);
        String resourceKey = this.keyBuilder.layerMetadata(layerName);
        try {
            this.client.putProperties(resourceKey, properties);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties getLayerMetadata(String layerName) {
        String key = this.keyBuilder.layerMetadata(layerName);
        try {
            return this.client.getProperties(key);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean layerExists(String layerName) {
        String coordsPrefix = this.keyBuilder.forLayer(layerName);
        return this.client.listBlobs(coordsPrefix, 1).size() > 0;
    }

    public Map<String, Optional<Map<String, String>>> getParametersMapping(String layerName) {
        List<BlobItem> items = this.client.listBlobs(this.keyBuilder.parametersMetadataPrefix(layerName), Integer.MAX_VALUE);
        HashMap<String, Optional<Map<String, String>>> result = new HashMap<String, Optional<Map<String, String>>>();
        try {
            for (BlobItem item : items) {
                Map<String, String> properties = this.client.getProperties(item.name()).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
                result.put(ParametersUtils.getId(properties), Optional.of(properties));
            }
            return result;
        }
        catch (StorageException e2) {
            throw new RuntimeException("Failed to retrieve properties mappings", e2);
        }
    }
}

