/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.azure.AzureBlobStoreInfo;

class AzureBlobStoreData {
    private String container;
    private String prefix;
    private String accountName;
    private String accountKey;
    private Integer maxConnections;
    private Boolean useHTTPS;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String serviceURL;

    AzureBlobStoreData() {
    }

    public AzureBlobStoreData(AzureBlobStoreInfo storeInfo, GeoWebCacheEnvironment environment) {
        environment.resolveValueIfEnabled(storeInfo.getContainer(), String.class).ifPresent(x -> {
            this.container = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getPrefix(), String.class).ifPresent(x -> {
            this.prefix = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getAccountName(), String.class).ifPresent(x -> {
            this.accountName = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getAccountKey(), String.class).ifPresent(x -> {
            this.accountKey = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getMaxConnections(), Integer.class).ifPresent(x -> {
            this.maxConnections = x;
        });
        this.useHTTPS = storeInfo.isUseHTTPS();
        environment.resolveValueIfEnabled(storeInfo.getProxyHost(), String.class).ifPresent(x -> {
            this.proxyHost = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getProxyPort(), Integer.class).ifPresent(x -> {
            this.proxyPort = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getProxyUsername(), String.class).ifPresent(x -> {
            this.proxyUsername = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getProxyPassword(), String.class).ifPresent(x -> {
            this.proxyPassword = x;
        });
        environment.resolveValueIfEnabled(storeInfo.getServiceURL(), String.class).ifPresent(x -> {
            this.serviceURL = x;
        });
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(Boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getLocation() {
        String container = this.getContainer();
        String prefix = this.getPrefix();
        if (prefix == null) {
            return String.format("container: %s", container);
        }
        return String.format("container: %s prefix: %s", container, prefix);
    }

    Proxy getProxy() {
        if (this.proxyHost != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort != null ? this.proxyPort : 8888));
        }
        return null;
    }
}

