/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.azure.AzureBlobStore;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageException;

public class AzureBlobStoreInfo
extends BlobStoreInfo {
    private static final long serialVersionUID = -8068069256598987874L;
    public static final int DEFAULT_CONNECTIONS = 100;
    static Logger log = Logging.getLogger((String)AzureBlobStoreInfo.class.getName());
    private String container;
    private String prefix;
    private String accountName;
    private String accountKey;
    private String maxConnections;
    private Boolean useHTTPS = true;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String serviceURL;

    public AzureBlobStoreInfo() {
    }

    public AzureBlobStoreInfo(String id) {
        super(id);
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    @Nullable
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMaxConnections() {
        return this.maxConnections == null ? String.valueOf(100) : this.maxConnections;
    }

    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(Boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public BlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        Preconditions.checkNotNull((Object)layers);
        Preconditions.checkState((this.getName() != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Can't call AzureBlobStoreConfig.createInstance() is blob store is not enabled");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Azure Blob Store instance [name=" + this.getName() + "]");
        }
        AzureBlobStoreData storeData = new AzureBlobStoreData(this, (GeoWebCacheEnvironment)GeoWebCacheExtensions.bean(GeoWebCacheEnvironment.class));
        return new AzureBlobStore(storeData, layers, lockProvider);
    }

    public String getLocation() {
        String container = this.getContainer();
        String prefix = this.getPrefix();
        if (prefix == null) {
            return String.format("container: %s", container);
        }
        return String.format("container: %s prefix: %s", container, prefix);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accountKey == null ? 0 : this.accountKey.hashCode());
        result = 31 * result + (this.accountName == null ? 0 : this.accountName.hashCode());
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.maxConnections == null ? 0 : this.maxConnections.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
        result = 31 * result + (this.proxyPassword == null ? 0 : this.proxyPassword.hashCode());
        result = 31 * result + (this.proxyPort == null ? 0 : this.proxyPort.hashCode());
        result = 31 * result + (this.proxyUsername == null ? 0 : this.proxyUsername.hashCode());
        result = 31 * result + (this.serviceURL == null ? 0 : this.serviceURL.hashCode());
        result = 31 * result + (this.useHTTPS == null ? 0 : this.useHTTPS.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AzureBlobStoreInfo other = (AzureBlobStoreInfo)((Object)obj);
        if (this.accountKey == null ? other.accountKey != null : !this.accountKey.equals(other.accountKey)) {
            return false;
        }
        if (this.accountName == null ? other.accountName != null : !this.accountName.equals(other.accountName)) {
            return false;
        }
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        if (this.maxConnections == null ? other.maxConnections != null : !this.maxConnections.equals(other.maxConnections)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
            return false;
        }
        if (this.proxyPassword == null ? other.proxyPassword != null : !this.proxyPassword.equals(other.proxyPassword)) {
            return false;
        }
        if (this.proxyPort == null ? other.proxyPort != null : !this.proxyPort.equals(other.proxyPort)) {
            return false;
        }
        if (this.proxyUsername == null ? other.proxyUsername != null : !this.proxyUsername.equals(other.proxyUsername)) {
            return false;
        }
        if (this.serviceURL == null ? other.serviceURL != null : !this.serviceURL.equals(other.serviceURL)) {
            return false;
        }
        return !(this.useHTTPS == null ? other.useHTTPS != null : !this.useHTTPS.equals(other.useHTTPS));
    }

    public String toString() {
        return "AzureBlobStoreInfo [container=" + this.container + ", prefix=" + this.prefix + ", accountName=" + this.accountName + ", accountKey=" + this.accountKey + ", maxConnections=" + this.maxConnections + ", useHTTPS=" + this.useHTTPS + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", serviceURL=" + this.serviceURL + ", getName()=" + this.getName() + ", getId()=" + this.getId() + ", isEnabled()=" + this.isEnabled() + ", isDefault()=" + this.isDefault() + "]";
    }
}

