/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.ContainerURL;
import com.microsoft.azure.storage.blob.DownloadResponse;
import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.azure.storage.blob.ListBlobsOptions;
import com.microsoft.azure.storage.blob.PipelineOptions;
import com.microsoft.azure.storage.blob.ServiceURL;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.models.BlobFlatListSegment;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlobItem;
import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import com.microsoft.azure.storage.blob.models.ContainerCreateResponse;
import com.microsoft.azure.storage.blob.models.ContainerListBlobFlatSegmentResponse;
import com.microsoft.rest.v2.RestException;
import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpClientConfiguration;
import com.microsoft.rest.v2.http.NettyClient;
import com.microsoft.rest.v2.http.SharedChannelPoolOptions;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.netty.bootstrap.Bootstrap;
import io.reactivex.Flowable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.storage.StorageException;
import org.springframework.http.HttpStatus;

class AzureClient
implements Closeable {
    private final NettyClient.Factory factory;
    private AzureBlobStoreData configuration;
    private final ContainerURL container;

    public AzureClient(AzureBlobStoreData configuration) throws StorageException {
        this.configuration = configuration;
        try {
            HttpClient client;
            SharedKeyCredentials creds = new SharedKeyCredentials(configuration.getAccountName(), configuration.getAccountKey());
            this.factory = new NettyClient.Factory(new Bootstrap(), 0, new SharedChannelPoolOptions().withPoolSize(configuration.getMaxConnections().intValue()), null);
            Proxy proxy = configuration.getProxy();
            if (proxy != null) {
                HttpClientConfiguration clientConfiguration = new HttpClientConfiguration(proxy);
                client = this.factory.create(clientConfiguration);
            } else {
                client = this.factory.create(null);
            }
            PipelineOptions options = new PipelineOptions().withClient(client);
            ServiceURL serviceURL = new ServiceURL(new URL(this.getServiceURL(configuration)), StorageURL.createPipeline((ICredentials)creds, (PipelineOptions)options));
            String containerName = configuration.getContainer();
            this.container = serviceURL.createContainerURL(containerName);
            try {
                int status = ((ContainerCreateResponse)this.container.create(null, null, null).blockingGet()).statusCode();
                if (!HttpStatus.valueOf((int)status).is2xxSuccessful() && status != HttpStatus.CONFLICT.value()) {
                    throw new StorageException("Failed to create container " + containerName + ", REST API returned a " + status);
                }
            }
            catch (RestException e) {
                if (e.response().statusCode() != HttpStatus.CONFLICT.value()) {
                    throw new StorageException("Failed to create container", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new StorageException("Failed to setup Azure connection and container", (Throwable)e);
        }
    }

    public String getServiceURL(AzureBlobStoreData configuration) {
        Object serviceURL = configuration.getServiceURL();
        if (serviceURL == null) {
            serviceURL = (configuration.isUseHTTPS() != false ? "https" : "http") + "://" + configuration.getAccountName() + ".blob.core.windows.net";
        }
        return serviceURL;
    }

    public BlockBlobURL getBlockBlobURL(String key) {
        return this.container.createBlockBlobURL(key);
    }

    @Nullable
    public byte[] getBytes(String key) throws StorageException {
        BlockBlobURL blob = this.getBlockBlobURL(key);
        try {
            DownloadResponse response = (DownloadResponse)blob.download().blockingGet();
            ByteBuffer buffer = (ByteBuffer)FlowableUtil.collectBytesInBuffer((Flowable)response.body(null)).blockingGet();
            byte[] result = new byte[buffer.remaining()];
            buffer.get(result);
            return result;
        }
        catch (RestException e) {
            if (e.response().statusCode() == 404) {
                return null;
            }
            throw new StorageException("Failed to retreive bytes for " + key, (Throwable)e);
        }
    }

    public Properties getProperties(String key) throws StorageException {
        Properties properties = new Properties();
        byte[] bytes = this.getBytes(key);
        if (bytes != null) {
            try {
                properties.load(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public void putProperties(String resourceKey, Properties properties) throws StorageException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            properties.store(out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            BlockBlobURL blob = this.getBlockBlobURL(resourceKey);
            byte[] bytes = out.toByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            BlobHTTPHeaders headers = new BlobHTTPHeaders();
            headers.withBlobContentType("text/plain");
            int status = ((BlockBlobUploadResponse)blob.upload(Flowable.just((Object)buffer), (long)bytes.length, headers, null, null, null).blockingGet()).statusCode();
            if (!HttpStatus.valueOf((int)status).is2xxSuccessful()) {
                throw new StorageException("Upload request failed with status " + status + " on resource " + resourceKey);
            }
        }
        catch (RestException e) {
            throw new StorageException("Failed to update e property file at " + resourceKey, (Throwable)e);
        }
    }

    public List<BlobItem> listBlobs(String prefix, Integer maxResults) {
        ContainerListBlobFlatSegmentResponse response = (ContainerListBlobFlatSegmentResponse)this.container.listBlobsFlatSegment(null, new ListBlobsOptions().withPrefix(prefix).withMaxResults(maxResults)).blockingGet();
        BlobFlatListSegment segment = response.body().segment();
        ArrayList<BlobItem> items = new ArrayList<BlobItem>();
        if (segment != null) {
            items.addAll(segment.blobItems());
        }
        return items;
    }

    @Override
    public void close() {
        this.factory.close();
    }

    public String getContainerName() {
        return this.configuration.getContainer();
    }

    public ContainerURL getContainer() {
        return this.container;
    }
}

