/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.azure.storage.blob.ContainerURL;
import com.microsoft.azure.storage.blob.ListBlobsOptions;
import com.microsoft.azure.storage.blob.models.BlobDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobFlatListSegment;
import com.microsoft.azure.storage.blob.models.BlobItem;
import com.microsoft.azure.storage.blob.models.ContainerListBlobFlatSegmentResponse;
import com.microsoft.rest.v2.RestException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.azure.AzureBlobStore;
import org.geowebcache.azure.AzureClient;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.TMSKeyBuilder;
import org.springframework.http.HttpStatus;

class DeleteManager
implements Closeable {
    static final int PAGE_SIZE = 1000;
    private final TMSKeyBuilder keyBuilder;
    private final AzureClient client;
    private final LockProvider locks;
    private final int concurrency;
    private ExecutorService deleteExecutor;
    private Map<String, Long> pendingDeletesKeyTime = new ConcurrentHashMap<String, Long>();

    public DeleteManager(AzureClient client, LockProvider locks, TMSKeyBuilder keyBuilder, int maxConnections) {
        this.keyBuilder = keyBuilder;
        this.client = client;
        this.locks = locks;
        this.concurrency = maxConnections;
        this.deleteExecutor = DeleteManager.createDeleteExecutorService(client.getContainerName(), maxConnections);
    }

    private static ExecutorService createDeleteExecutorService(String containerName, int parallelism) {
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("GWC AzureBlobStore bulk delete thread-%d. Container: " + containerName).setPriority(1).build();
        return Executors.newFixedThreadPool(parallelism, tf);
    }

    private long currentTimeSeconds() {
        long timestamp = (long)Math.ceil((double)System.currentTimeMillis() / 1000.0) * 1000L;
        return timestamp;
    }

    public void executeParallel(List<Callable<?>> callables) throws StorageException {
        ArrayList futures = new ArrayList();
        for (Callable<?> callable : callables) {
            futures.add(this.deleteExecutor.submit(callable));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new StorageException("Failed to execute parallel delete", (Throwable)e);
            }
        }
    }

    public Long deleteParallel(List<String> keys) throws StorageException {
        try {
            return new KeysBulkDelete(keys).call();
        }
        catch (Exception e) {
            throw new StorageException("Failed to submit parallel keys execution", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleAsyncDelete(String prefix) throws StorageException {
        boolean bl;
        long timestamp = this.currentTimeSeconds();
        String msg = String.format("Issuing bulk delete on '%s/%s' for objects older than %d", this.client.getContainerName(), prefix, timestamp);
        AzureBlobStore.log.info(msg);
        LockProvider.Lock lock = this.locks.getLock(prefix);
        try {
            boolean taskRuns = this.asyncDelete(prefix, timestamp);
            if (taskRuns) {
                String pendingDeletesKey = this.keyBuilder.pendingDeletes();
                Properties deletes = this.client.getProperties(pendingDeletesKey);
                deletes.setProperty(prefix, String.valueOf(timestamp));
                this.client.putProperties(pendingDeletesKey, deletes);
            }
            bl = taskRuns;
        }
        catch (Throwable throwable) {
            try {
                lock.release();
                throw throwable;
            }
            catch (GeoWebCacheException e) {
                throw new StorageException("Failed to schedule asynch delete ", (Throwable)e);
            }
        }
        lock.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issuePendingBulkDeletes() throws StorageException {
        LockProvider.Lock lock;
        String pendingDeletesKey = this.keyBuilder.pendingDeletes();
        try {
            lock = this.locks.getLock(pendingDeletesKey);
        }
        catch (GeoWebCacheException e) {
            throw new StorageException("Unable to lock pending deletes", (Throwable)e);
        }
        try {
            Properties deletes = this.client.getProperties(pendingDeletesKey);
            for (Map.Entry<Object, Object> e : deletes.entrySet()) {
                String prefix = e.getKey().toString();
                long timestamp = Long.parseLong(e.getValue().toString());
                AzureBlobStore.log.info(String.format("Restarting pending bulk delete on '%s/%s':%d", this.client.getContainerName(), prefix, timestamp));
                this.asyncDelete(prefix, timestamp);
            }
        }
        finally {
            try {
                lock.release();
            }
            catch (GeoWebCacheException e) {
                throw new StorageException("Unable to unlock pending deletes", (Throwable)e);
            }
        }
    }

    public synchronized boolean asyncDelete(String prefix, long timestamp) {
        if (this.client.listBlobs(prefix, 1).size() == 0) {
            return false;
        }
        Long currentTaskTime = this.pendingDeletesKeyTime.get(prefix);
        if (currentTaskTime != null && currentTaskTime > timestamp) {
            return false;
        }
        PrefixTimeBulkDelete task = new PrefixTimeBulkDelete(prefix, timestamp);
        this.deleteExecutor.submit(task);
        this.pendingDeletesKeyTime.put(prefix, timestamp);
        return true;
    }

    private void clearPendingBulkDelete(String prefix, long timestamp) throws GeoWebCacheException {
        Long taskTime = this.pendingDeletesKeyTime.get(prefix);
        if (taskTime == null) {
            return;
        }
        if (taskTime > timestamp) {
            return;
        }
        String pendingDeletesKey = this.keyBuilder.pendingDeletes();
        LockProvider.Lock lock = this.locks.getLock(pendingDeletesKey);
        try {
            long storedTimestamp;
            Properties deletes = this.client.getProperties(pendingDeletesKey);
            String storedVal = (String)deletes.remove(prefix);
            long l = storedTimestamp = storedVal == null ? Long.MIN_VALUE : Long.parseLong(storedVal);
            if (timestamp >= storedTimestamp) {
                this.client.putProperties(pendingDeletesKey, deletes);
            } else {
                AzureBlobStore.log.info(String.format("bulk delete finished but there's a newer one ongoing for container '%s/%s'", this.client.getContainerName(), prefix));
            }
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void close() {
        this.deleteExecutor.shutdownNow();
    }

    void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public class KeysBulkDelete
    implements Callable<Long> {
        private final List<String> keys;

        public KeysBulkDelete(List<String> keys) {
            this.keys = keys;
        }

        @Override
        public Long call() throws Exception {
            long count = 0L;
            try {
                DeleteManager.this.checkInterrupted();
                if (AzureBlobStore.log.isLoggable(Level.FINER)) {
                    AzureBlobStore.log.finer(String.format("Running delete delete on list of items on '%s':%s ... (only the first 100 items listed)", DeleteManager.this.client.getContainerName(), this.keys.subList(0, Math.min(this.keys.size(), 100))));
                }
                ContainerURL container = DeleteManager.this.client.getContainer();
                for (int i = 0; i < this.keys.size(); i += 1000) {
                    this.deleteItems(container, this.keys.subList(i, Math.min(i + 1000, this.keys.size())));
                }
            }
            catch (IllegalStateException | InterruptedException e) {
                AzureBlobStore.log.log(Level.INFO, "Azure bulk delete aborted", e);
                throw e;
            }
            catch (Exception e) {
                AzureBlobStore.log.log(Level.WARNING, "Unknown error performing bulk Azure delete", e);
                throw e;
            }
            AzureBlobStore.log.info(String.format("Finished bulk delete on %s, %d objects deleted", DeleteManager.this.client.getContainerName(), count));
            return count;
        }

        private long deleteItems(ContainerURL container, List<String> itemNames) throws ExecutionException, InterruptedException {
            List collect = itemNames.stream().map(item -> DeleteManager.this.deleteExecutor.submit(() -> this.deleteItem(container, (String)item))).collect(Collectors.toList());
            for (Future f : collect) {
                f.get();
            }
            return collect.size();
        }

        private Object deleteItem(ContainerURL container, String item) {
            block3: {
                try {
                    int status = ((BlobDeleteResponse)container.createBlobURL(item).delete().blockingGet()).statusCode();
                    if (status != HttpStatus.NOT_FOUND.value() && !HttpStatus.valueOf((int)status).is2xxSuccessful()) {
                        throw new RuntimeException("Deletion failed with status " + status + " on resource " + item);
                    }
                }
                catch (RestException e) {
                    if (e.response().statusCode() == HttpStatus.NOT_FOUND.value()) break block3;
                    throw new RuntimeException("Deletion failed with status " + e.response().statusCode() + " on resource " + item, e);
                }
            }
            return null;
        }
    }

    public class PrefixTimeBulkDelete
    implements Callable<Long> {
        private final String prefix;
        private final long timestamp;

        public PrefixTimeBulkDelete(String prefix, long timestamp) {
            this.prefix = prefix;
            this.timestamp = timestamp;
        }

        @Override
        public Long call() throws Exception {
            long count = 0L;
            try {
                DeleteManager.this.checkInterrupted();
                AzureBlobStore.log.info(String.format("Running bulk delete on '%s/%s':%d", DeleteManager.this.client.getContainerName(), this.prefix, this.timestamp));
                ContainerURL container = DeleteManager.this.client.getContainer();
                int jobPageSize = Math.max(DeleteManager.this.concurrency, 1000);
                ListBlobsOptions options = new ListBlobsOptions().withPrefix(this.prefix).withMaxResults(Integer.valueOf(jobPageSize));
                ContainerListBlobFlatSegmentResponse response = (ContainerListBlobFlatSegmentResponse)container.listBlobsFlatSegment(null, options, null).blockingGet();
                Predicate<BlobItem> filter = blobItem -> {
                    long lastModified = blobItem.properties().lastModified().toEpochSecond() * 1000L;
                    return this.timestamp >= lastModified;
                };
                while (response.body().segment() != null) {
                    DeleteManager.this.checkInterrupted();
                    this.deleteItems(container, response.body().segment(), filter);
                    String marker = response.body().nextMarker();
                    if (marker != null) {
                        response = (ContainerListBlobFlatSegmentResponse)container.listBlobsFlatSegment(marker, options, null).blockingGet();
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalStateException | InterruptedException e) {
                AzureBlobStore.log.info(String.format("Azure bulk delete aborted for '%s/%s'. Will resume on next startup.", DeleteManager.this.client.getContainerName(), this.prefix));
                throw e;
            }
            catch (Exception e) {
                AzureBlobStore.log.log(Level.WARNING, String.format("Unknown error performing bulk Azure blobs delete of '%s/%s'", DeleteManager.this.client.getContainerName(), this.prefix), e);
                throw e;
            }
            AzureBlobStore.log.info(String.format("Finished bulk delete on '%s/%s':%d. %d objects deleted", DeleteManager.this.client.getContainerName(), this.prefix, this.timestamp, count));
            DeleteManager.this.clearPendingBulkDelete(this.prefix, this.timestamp);
            return count;
        }

        private long deleteItems(ContainerURL container, BlobFlatListSegment segment, Predicate<BlobItem> filter) throws ExecutionException, InterruptedException {
            List collect = segment.blobItems().stream().filter(item -> filter.test((BlobItem)item)).map(item -> DeleteManager.this.deleteExecutor.submit(() -> {
                this.deleteItem(container, (BlobItem)item);
                return null;
            })).collect(Collectors.toList());
            for (Future f : collect) {
                f.get();
            }
            return collect.size();
        }

        private void deleteItem(ContainerURL container, BlobItem item) {
            block3: {
                String key = item.name();
                try {
                    int status = ((BlobDeleteResponse)container.createBlobURL(key).delete().blockingGet()).statusCode();
                    if (status != HttpStatus.NOT_FOUND.value() && !HttpStatus.valueOf((int)status).is2xxSuccessful()) {
                        throw new RuntimeException("Deletion failed with status " + status + " on resource " + key);
                    }
                }
                catch (RestException e) {
                    if (e.response().statusCode() == HttpStatus.NOT_FOUND.value()) break block3;
                    throw new RuntimeException("Deletion failed with status " + e.response().statusCode() + " on resource " + key, e);
                }
            }
        }
    }
}

