/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.demo.Demo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class DemoTest {
    @Test
    public void testAdvertised() throws GeoWebCacheException, IOException {
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest servReq = new MockHttpServletRequest();
        servReq.setRequestURI("/test");
        HashMap subSets = new HashMap();
        WMSLayer advertisedLayer = new WMSLayer("testAdv", null, null, null, null, subSets, null, null, null, false, null);
        advertisedLayer.setEnabled(true);
        advertisedLayer.setAdvertised(true);
        WMSLayer unAdvertisedLayer = new WMSLayer("testNotAdv", null, null, null, null, subSets, null, null, null, false, null);
        unAdvertisedLayer.setEnabled(true);
        unAdvertisedLayer.setAdvertised(false);
        TreeSet<String> set = new TreeSet<String>();
        set.add(advertisedLayer.getName());
        set.add(unAdvertisedLayer.getName());
        Mockito.when((Object)tld.getLayerNames()).thenReturn(set);
        Mockito.when((Object)tld.getTileLayer("testAdv")).thenReturn((Object)advertisedLayer);
        Mockito.when((Object)tld.getTileLayer("testNotAdv")).thenReturn((Object)unAdvertisedLayer);
        Demo.makeMap((TileLayerDispatcher)tld, null, null, (HttpServletRequest)servReq, (HttpServletResponse)response);
        String result = response.getContentAsString();
        Assert.assertTrue((boolean)result.contains("testAdv"));
        Assert.assertFalse((boolean)result.contains("testNotAdv"));
    }
}

