/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.easymock.MockType;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.MockExtensionRule;
import org.geowebcache.TestHelpers;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class GeoWebCacheDispatcherTest {
    @Rule
    public MockExtensionRule extensions = new MockExtensionRule();

    @Test
    public void testHomePage() throws Exception {
        IMocksControl stubs = EasyMock.createControl((MockType)MockType.NICE);
        TileLayerDispatcher tld = (TileLayerDispatcher)stubs.createMock("tld", TileLayerDispatcher.class);
        GridSetBroker gsb = (GridSetBroker)stubs.createMock("gsb", GridSetBroker.class);
        StorageBroker sb = (StorageBroker)stubs.createMock("sb", StorageBroker.class);
        BlobStoreAggregator bsa = (BlobStoreAggregator)stubs.createMock("bsa", BlobStoreAggregator.class);
        ServerConfiguration config = (ServerConfiguration)stubs.createMock("config", ServerConfiguration.class);
        RuntimeStats rts = (RuntimeStats)stubs.createMock("rts", RuntimeStats.class);
        DefaultStorageFinder dfs = (DefaultStorageFinder)stubs.createMock("dfs", DefaultStorageFinder.class);
        SecurityDispatcher secDisp = (SecurityDispatcher)stubs.createMock("secDisp", SecurityDispatcher.class);
        EasyMock.expect((Object)config.isRuntimeStatsEnabled()).andStubReturn((Object)false);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/geowebcache/home");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContextPath("/geowebcache");
        stubs.replay();
        GeoWebCacheDispatcher dispatcher = new GeoWebCacheDispatcher(tld, gsb, sb, bsa, config, rts);
        dispatcher.setApplicationContext(this.extensions.getMockContext());
        dispatcher.setDefaultStorageFinder(dfs);
        dispatcher.setSecurityDispatcher(secDisp);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertThat((Object)response, TestHelpers.hasStatus(HttpStatus.OK));
        stubs.verify();
    }

    @Test
    public void testRequestNoSecurity() throws Exception {
        IMocksControl stubs = EasyMock.createControl((MockType)MockType.NICE);
        TileLayerDispatcher tld = (TileLayerDispatcher)stubs.createMock("tld", TileLayerDispatcher.class);
        GridSetBroker gsb = (GridSetBroker)stubs.createMock("gsb", GridSetBroker.class);
        StorageBroker sb = (StorageBroker)stubs.createMock("sb", StorageBroker.class);
        BlobStoreAggregator bsa = (BlobStoreAggregator)stubs.createMock("bsa", BlobStoreAggregator.class);
        ServerConfiguration config = (ServerConfiguration)stubs.createMock("config", ServerConfiguration.class);
        RuntimeStats rts = (RuntimeStats)stubs.createMock("rts", RuntimeStats.class);
        DefaultStorageFinder dfs = (DefaultStorageFinder)stubs.createMock("dfs", DefaultStorageFinder.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)stubs.createMock("subset", GridSubset.class);
        SecurityDispatcher secDisp = (SecurityDispatcher)stubs.createMock("secDisp", SecurityDispatcher.class);
        SRS srs = SRS.getEPSG3857();
        EasyMock.expect((Object)config.isRuntimeStatsEnabled()).andStubReturn((Object)false);
        Service testService = (Service)EasyMock.createMock((String)"testService", Service.class);
        EasyMock.expect((Object)testService.getPathName()).andStubReturn((Object)"testService");
        EasyMock.expect((Object)tld.getTileLayer("testLayer")).andStubReturn((Object)layer);
        EasyMock.expect((Object)layer.isEnabled()).andStubReturn((Object)true);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/geowebcache/service/testService/testRequest1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContextPath("/geowebcache");
        ConveyorTile conv = new ConveyorTile(sb, "testLayer", "testGrid", new long[]{1L, 2L, 3L}, (MimeType)ImageMime.png, Collections.emptyMap(), (HttpServletRequest)request, (HttpServletResponse)response);
        layer.applyRequestFilters(conv);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)testService.getConveyor((HttpServletRequest)EasyMock.eq((Object)request), (HttpServletResponse)EasyMock.anyObject(HttpServletResponse.class))).andReturn((Object)conv);
        EasyMock.expect((Object)layer.getTile(conv)).andReturn((Object)conv).once();
        EasyMock.expect((Object)layer.getGridSubset("testGrid")).andStubReturn((Object)subset);
        EasyMock.expect((Object)layer.useETags()).andStubReturn((Object)false);
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)new BoundingBox(10.0, 20.0, 30.0, 40.0));
        EasyMock.expect((Object)subset.getName()).andStubReturn((Object)"testGrid");
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        secDisp.checkSecurity(conv);
        EasyMock.expectLastCall().once();
        stubs.replay();
        EasyMock.replay((Object[])new Object[]{testService, layer});
        this.extensions.addBean("testService", testService, Service.class);
        GeoWebCacheDispatcher dispatcher = new GeoWebCacheDispatcher(tld, gsb, sb, bsa, config, rts);
        dispatcher.setApplicationContext(this.extensions.getMockContext());
        dispatcher.setDefaultStorageFinder(dfs);
        dispatcher.setSecurityDispatcher(secDisp);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertThat((Object)response, TestHelpers.hasStatus(HttpStatus.OK));
        stubs.verify();
        EasyMock.verify((Object[])new Object[]{testService, layer});
    }

    @Test
    public void testRequestFail() throws Exception {
        IMocksControl stubs = EasyMock.createControl((MockType)MockType.NICE);
        TileLayerDispatcher tld = (TileLayerDispatcher)stubs.createMock("tld", TileLayerDispatcher.class);
        GridSetBroker gsb = (GridSetBroker)stubs.createMock("gsb", GridSetBroker.class);
        StorageBroker sb = (StorageBroker)stubs.createMock("sb", StorageBroker.class);
        BlobStoreAggregator bsa = (BlobStoreAggregator)stubs.createMock("bsa", BlobStoreAggregator.class);
        ServerConfiguration config = (ServerConfiguration)stubs.createMock("config", ServerConfiguration.class);
        RuntimeStats rts = (RuntimeStats)stubs.createMock("rts", RuntimeStats.class);
        DefaultStorageFinder dfs = (DefaultStorageFinder)stubs.createMock("dfs", DefaultStorageFinder.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)stubs.createMock("subset", GridSubset.class);
        SecurityDispatcher secDisp = (SecurityDispatcher)stubs.createMock("secDisp", SecurityDispatcher.class);
        SRS srs = SRS.getEPSG3857();
        EasyMock.expect((Object)config.isRuntimeStatsEnabled()).andStubReturn((Object)false);
        Service testService = (Service)EasyMock.createMock((String)"testService", Service.class);
        EasyMock.expect((Object)testService.getPathName()).andStubReturn((Object)"testService");
        EasyMock.expect((Object)tld.getTileLayer("testLayer")).andStubReturn((Object)layer);
        EasyMock.expect((Object)layer.isEnabled()).andStubReturn((Object)true);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/geowebcache/service/testService/testRequest1");
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContextPath("/geowebcache");
        ConveyorTile conv = new ConveyorTile(sb, "testLayer", "testGrid", new long[]{1L, 2L, 3L}, (MimeType)ImageMime.png, Collections.emptyMap(), (HttpServletRequest)request, (HttpServletResponse)response);
        layer.applyRequestFilters(conv);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)testService.getConveyor((HttpServletRequest)EasyMock.eq((Object)request), (HttpServletResponse)EasyMock.anyObject(HttpServletResponse.class))).andReturn((Object)conv);
        EasyMock.expect((Object)layer.getGridSubset("testGrid")).andStubReturn((Object)subset);
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)new BoundingBox(10.0, 20.0, 30.0, 40.0));
        EasyMock.expect((Object)subset.getName()).andStubReturn((Object)"testGrid");
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        secDisp.checkSecurity(conv);
        EasyMock.expectLastCall().andThrow((Throwable)new SecurityException("Unauthorized because TEST"));
        stubs.replay();
        EasyMock.replay((Object[])new Object[]{testService, layer});
        this.extensions.addBean("testService", testService, Service.class);
        GeoWebCacheDispatcher dispatcher = new GeoWebCacheDispatcher(tld, gsb, sb, bsa, config, rts);
        dispatcher.setApplicationContext(this.extensions.getMockContext());
        dispatcher.setDefaultStorageFinder(dfs);
        dispatcher.setSecurityDispatcher(secDisp);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertThat((Object)response, TestHelpers.hasStatus(HttpStatus.FORBIDDEN));
        stubs.verify();
        EasyMock.verify((Object[])new Object[]{testService, layer});
    }
}

