/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeoWebCacheEnvironmentTest {
    @Before
    public void setUp() throws Exception {
        System.setProperty("TEST_SYS_PROPERTY", "ABC");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("TEST_SYS_PROPERTY", "");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "");
    }

    @Test
    public void testEnvironment() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheEnvironment genv = new GeoWebCacheEnvironment();
        Assert.assertEquals((long)0L, (long)GeoWebCacheExtensions.extensionsCache.size());
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoWebCacheEnvironment.class)).andReturn((Object)new String[]{"geoWebCacheEnvironment"});
        EasyMock.expect((Object)appContext.getBean("geoWebCacheEnvironment")).andReturn((Object)genv);
        HashMap<String, GeoWebCacheEnvironment> genvMap = new HashMap<String, GeoWebCacheEnvironment>();
        genvMap.put("geoWebCacheEnvironment", genv);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoWebCacheEnvironment.class)).andReturn(genvMap).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext(appContext);
        List extensions = GeoWebCacheExtensions.extensions(GeoWebCacheEnvironment.class);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertTrue((boolean)extensions.contains(genv));
        Assert.assertTrue((boolean)GeoWebCacheEnvironment.ALLOW_ENV_PARAMETRIZATION);
    }

    @Test
    public void testSystemProperty() {
        GeoWebCacheEnvironment genv = new GeoWebCacheEnvironment();
        Assert.assertEquals((Object)"ABC", (Object)genv.resolveValue((Object)"${TEST_SYS_PROPERTY}"));
        Properties props = new Properties();
        props.setProperty("TEST_SYS_PROPERTY", "DEF");
        props.setProperty("TEST_PROPERTY", "WWW");
        genv.setProps(props);
        Assert.assertEquals((Object)"ABC", (Object)genv.resolveValue((Object)"${TEST_SYS_PROPERTY}"));
        Assert.assertEquals((Object)"WWW", (Object)genv.resolveValue((Object)"${TEST_PROPERTY}"));
    }
}

