/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheExtensionPriority;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class GeoWebCacheExtensionsTest {
    @Rule
    public PropertyRule testProperty = PropertyRule.system("TEST_PROPERTY");
    @Rule
    public MockWepAppContextRule contextRule = new MockWepAppContextRule();

    @Test
    public void testSetApplicationContext() {
        ApplicationContext appContext1 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext appContext2 = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext(appContext1);
        GeoWebCacheExtensions.extensionsCache.put(GeoWebCacheExtensionsTest.class, new String[]{"fake"});
        Assert.assertSame((Object)appContext1, (Object)GeoWebCacheExtensions.context);
        gse.setApplicationContext(appContext2);
        Assert.assertSame((Object)appContext2, (Object)GeoWebCacheExtensions.context);
        Assert.assertEquals((long)0L, (long)GeoWebCacheExtensions.extensionsCache.size());
    }

    @Test
    public void testExtensions() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext(appContext);
        HashMap<String, GeoWebCacheExtensionsTest> beans = new HashMap<String, GeoWebCacheExtensionsTest>();
        beans.put("testKey", this);
        beans.put("fakeKey", null);
        Assert.assertEquals((long)0L, (long)GeoWebCacheExtensions.extensionsCache.size());
        EasyMock.expect((Object)appContext.getBeansOfType(GeoWebCacheExtensionsTest.class)).andReturn(beans);
        EasyMock.expect((Object)appContext.getBean("testKey")).andReturn((Object)this);
        EasyMock.expect((Object)appContext.getBean("fakeKey")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoWebCacheExtensions.extensions(GeoWebCacheExtensionsTest.class);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)2L, (long)extensions.size());
        Assert.assertTrue((boolean)extensions.contains(this));
        Assert.assertTrue((boolean)extensions.contains(null));
        Assert.assertEquals((long)1L, (long)GeoWebCacheExtensions.extensionsCache.size());
        Assert.assertTrue((boolean)GeoWebCacheExtensions.extensionsCache.containsKey(GeoWebCacheExtensionsTest.class));
        Assert.assertNotNull(GeoWebCacheExtensions.extensionsCache.get(GeoWebCacheExtensionsTest.class));
        Assert.assertEquals((long)2L, (long)((String[])GeoWebCacheExtensions.extensionsCache.get(GeoWebCacheExtensionsTest.class)).length);
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    @Test
    public void testExtensionsApplicationContext() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        ApplicationContext customAppContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext(appContext);
        HashMap<String, GeoWebCacheExtensionsTest> beans = new HashMap<String, GeoWebCacheExtensionsTest>();
        beans.put("itDoesntMatterForThePurpose", this);
        Assert.assertEquals((long)0L, (long)GeoWebCacheExtensions.extensionsCache.size());
        EasyMock.expect((Object)customAppContext.getBeansOfType(GeoWebCacheExtensionsTest.class)).andReturn(beans);
        EasyMock.expect((Object)customAppContext.getBean("itDoesntMatterForThePurpose")).andReturn((Object)this);
        EasyMock.replay((Object[])new Object[]{customAppContext});
        EasyMock.replay((Object[])new Object[]{appContext});
        List extensions = GeoWebCacheExtensions.extensions(GeoWebCacheExtensionsTest.class, (ApplicationContext)customAppContext);
        Assert.assertNotNull((Object)extensions);
        Assert.assertEquals((long)1L, (long)extensions.size());
        Assert.assertSame((Object)this, extensions.get(0));
        Assert.assertEquals((long)0L, (long)GeoWebCacheExtensions.extensionsCache.size());
        EasyMock.verify((Object[])new Object[]{appContext});
        EasyMock.verify((Object[])new Object[]{customAppContext});
    }

    @Test
    public void testBeanString() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        gse.setApplicationContext(null);
        Assert.assertNull((Object)GeoWebCacheExtensions.bean((String)"beanName"));
        gse.setApplicationContext(appContext);
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn(null);
        EasyMock.expect((Object)appContext.getBean("beanName")).andReturn((Object)this);
        EasyMock.replay((Object[])new Object[]{appContext});
        Assert.assertNull((Object)GeoWebCacheExtensions.bean((String)"beanName"));
        Assert.assertSame((Object)this, (Object)GeoWebCacheExtensions.bean((String)"beanName"));
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    @Test
    public void testSystemProperty() {
        this.testProperty.setValue("ABC");
        Assert.assertEquals((Object)"ABC", (Object)GeoWebCacheExtensions.getProperty((String)"TEST_PROPERTY", (ApplicationContext)null));
    }

    @Test
    public void testWebProperty() {
        PropertyRule higerPrecedence = this.testProperty;
        higerPrecedence.setValue("ABC");
        ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)servletContext.getInitParameter("TEST_PROPERTY")).andReturn((Object)"DEF").anyTimes();
        EasyMock.expect((Object)servletContext.getInitParameter("WEB_PROPERTY")).andReturn((Object)"WWW").anyTimes();
        EasyMock.replay((Object[])new Object[]{servletContext});
        WebApplicationContext webAppContext = (WebApplicationContext)EasyMock.createMock(WebApplicationContext.class);
        EasyMock.expect((Object)webAppContext.getServletContext()).andReturn((Object)servletContext).anyTimes();
        EasyMock.replay((Object[])new Object[]{webAppContext});
        Assert.assertEquals((Object)higerPrecedence.getValue(), (Object)GeoWebCacheExtensions.getProperty((String)"TEST_PROPERTY", (ApplicationContext)webAppContext));
        Assert.assertEquals((Object)"WWW", (Object)GeoWebCacheExtensions.getProperty((String)"WEB_PROPERTY", (ApplicationContext)webAppContext));
    }

    @Test
    public void testExtensionsWithPriority() {
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        BeanWithPriority beanA = new BeanWithPriority(15, "beanA");
        BeanWithPriority beanB = new BeanWithPriority(3, "beanB");
        BeanWithPriority beanC = new BeanWithPriority(27, "beanC");
        HashMap<String, BeanWithPriority> beans = new HashMap<String, BeanWithPriority>();
        beans.put("beanA", beanA);
        beans.put("beanB", beanB);
        beans.put("beanC", beanC);
        EasyMock.expect((Object)appContext.getBeansOfType(BeanWithPriority.class)).andReturn(beans);
        EasyMock.expect((Object)appContext.getBean("beanA")).andReturn((Object)beanA);
        EasyMock.expect((Object)appContext.getBean("beanB")).andReturn((Object)beanB);
        EasyMock.expect((Object)appContext.getBean("beanC")).andReturn((Object)beanC);
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoWebCacheExtensions gwcExtensions = new GeoWebCacheExtensions();
        gwcExtensions.setApplicationContext(appContext);
        Assert.assertThat((Object)GeoWebCacheExtensions.extensionsCache.size(), (Matcher)Matchers.is((Object)0));
        List extensions = GeoWebCacheExtensions.extensions(BeanWithPriority.class);
        Assert.assertThat((Object)extensions.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)extensions, (Matcher)Matchers.contains((Object[])new BeanWithPriority[]{beanB, beanA, beanC}));
        EasyMock.verify((Object[])new Object[]{appContext});
    }

    private static final class BeanWithPriority
    implements GeoWebCacheExtensionPriority {
        final int priority;
        final String id;

        public BeanWithPriority(int priority, String id) {
            this.priority = priority;
            this.id = id;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

