/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.geowebcache.GeoWebCacheExtensions;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class MockExtensionRule
extends ExternalResource {
    static Lock lock = new ReentrantLock();
    static MockExtensionRule staticRule = null;
    ApplicationContext mockContext;
    ApplicationContext oldContext;
    Map<String, Object> beans = new HashMap<String, Object>();
    Map<Class<?>, Collection<String>> types = new HashMap();
    final boolean staticContext;

    public MockExtensionRule(boolean staticContext) {
        this.staticContext = staticContext;
    }

    public MockExtensionRule() {
        this(true);
    }

    protected void before() throws Throwable {
        this.mockContext = this.makeContext();
        if (this.staticContext) {
            lock.lock();
            if (Objects.nonNull((Object)staticRule)) {
                Assert.fail((String)"Only one static MockExtensionRule can be active at a time");
            } else {
                staticRule = this;
            }
            this.oldContext = GeoWebCacheExtensions.context;
            GeoWebCacheExtensions.extensionsCache.clear();
            GeoWebCacheExtensions.context = this.mockContext;
        }
    }

    protected ApplicationContext makeContext() throws IllegalArgumentException {
        return (ApplicationContext)Proxy.newProxyInstance(MockExtensionRule.class.getClassLoader(), new Class[]{ApplicationContext.class}, (InvocationHandler)new ContextInvocationHandler());
    }

    public void addBean(String name, Object bean, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            Collection c = this.types.getOrDefault(clazz, new ArrayList());
            c.add(name);
            this.types.put(clazz, c);
        }
        this.beans.put(name, bean);
        GeoWebCacheExtensions.extensionsCache.clear();
    }

    protected void after() {
        try {
            GeoWebCacheExtensions.extensionsCache.clear();
            if (this.staticContext) {
                GeoWebCacheExtensions.context = this.oldContext;
            }
        }
        finally {
            if (this.staticContext) {
                staticRule = null;
                lock.unlock();
            }
        }
    }

    public ApplicationContext getMockContext() {
        if (Objects.isNull(this.mockContext)) {
            throw new IllegalStateException("Mock context only available while rule is active");
        }
        return this.mockContext;
    }

    class ContextInvocationHandler
    implements InvocationHandler {
        ContextInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getBean")) {
                Iterator<Map.Entry<String, Object>> iterator;
                if (method.getParameterTypes()[0].equals(String.class)) {
                    return Optional.ofNullable(MockExtensionRule.this.beans.get(args[0])).orElseThrow(() -> new NoSuchBeanDefinitionException((String)args[0]));
                }
                if (method.getParameterTypes()[0].equals(Class.class) && (iterator = MockExtensionRule.this.beans.entrySet().iterator()).hasNext()) {
                    Map.Entry<String, Object> pair = iterator.next();
                    if (((Class)args[0]).isAssignableFrom(pair.getValue().getClass())) {
                        return pair.getValue();
                    }
                    throw new NoSuchBeanDefinitionException((Class)args[0]);
                }
            } else if (method.getName().equals("getBeansOfType")) {
                return ((Collection)MockExtensionRule.this.types.getOrDefault(args[0], Collections.emptySet())).stream().collect(Collectors.toMap(name -> name, MockExtensionRule.this.beans::get));
            }
            throw new UnsupportedOperationException();
        }
    }
}

