/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.util.MockLockProvider;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.springframework.http.HttpStatus;

public class TestHelpers {
    static GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
    public static MockLockProvider mockProvider = new MockLockProvider();

    public static byte[] createFakeSourceImage(WMSLayer layer) throws IOException {
        int tileWidth = layer.getGridSubset(gridSetBroker.getWorldEpsg4326().getName()).getGridSet().getTileWidth();
        int tileHeight = layer.getGridSubset(gridSetBroker.getWorldEpsg4326().getName()).getGridSet().getTileHeight();
        int width = tileWidth * layer.getMetaTilingFactors()[0];
        int height = tileHeight * layer.getMetaTilingFactors()[1];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage image = new BufferedImage(width, height, 2);
        String formatName = ((MimeType)layer.getMimeTypes().get(0)).getInternalName();
        ImageIO.write((RenderedImage)image, formatName, out);
        return out.toByteArray();
    }

    public static WMSLayer createWMSLayer(String format) {
        return TestHelpers.createWMSLayer(format, null, null);
    }

    public static WMSLayer createWMSLayer(String format, Integer minCacheLevel, Integer maxCacheLevel) {
        String[] urls = new String[]{"http://localhost:38080/wms"};
        List<String> formatList = Collections.singletonList(format);
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>();
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)gridSetBroker.getWorldEpsg4326(), (BoundingBox)new BoundingBox(-30.0, 15.0, 45.0, 30.0), (Integer)0, (Integer)10, (Integer)minCacheLevel, (Integer)maxCacheLevel);
        grids.put(grid.getName(), grid);
        int[] metaWidthHeight = new int[]{3, 3};
        WMSLayer layer = new WMSLayer("test:layer", urls, "aStyle", "test:layer", formatList, grids, new ArrayList(), metaWidthHeight, "vendorparam=true", false, null);
        layer.initialize(gridSetBroker);
        layer.setLockProvider((LockProvider)new MockLockProvider());
        return layer;
    }

    public static SeedRequest createRequest(WMSLayer tl, GWCTask.TYPE type, int zoomStart, int zoomStop) {
        String gridSet = (String)tl.getGridSubsets().iterator().next();
        BoundingBox bounds = null;
        int threadCount = 1;
        String format = ((MimeType)tl.getMimeTypes().get(0)).getFormat();
        SeedRequest req = new SeedRequest(tl.getName(), bounds, gridSet, threadCount, zoomStart, zoomStop, format, type, null);
        return req;
    }

    public static Matcher<HttpServletResponse> hasStatus(final HttpStatus expected) {
        return new BaseMatcher<HttpServletResponse>(){

            public boolean matches(Object item) {
                if (item instanceof HttpServletResponse) {
                    return expected.equals((Object)HttpStatus.valueOf((int)((HttpServletResponse)item).getStatus()));
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Http response with status ");
                this.describeStatus(expected, description);
            }

            protected void describeStatus(HttpStatus status, Description description) {
                description.appendValue((Object)status.value()).appendText(" ").appendValue((Object)status.getReasonPhrase());
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof HttpServletResponse) {
                    HttpStatus status = HttpStatus.valueOf((int)((HttpServletResponse)item).getStatus());
                    description.appendText("status was ");
                    this.describeStatus(status, description);
                } else {
                    description.appendText("was not an HttpServletResponse");
                }
            }
        };
    }
}

