/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.file;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.DefaultFilePathFilter;
import org.geowebcache.storage.blobstore.file.DefaultFilePathGenerator;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultFilePathGeneratorTest {
    FilePathGenerator generator;
    File testRoot;

    @Before
    public void setUp() throws Exception {
        this.testRoot = new File("./target/pathGeneratorTests");
        if (this.testRoot.exists()) {
            this.testRoot.delete();
            FileUtils.deleteDirectory((File)this.testRoot);
        }
        this.testRoot.mkdir();
        this.generator = new DefaultFilePathGenerator(this.testRoot.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testRoot);
    }

    @Test
    public void testPathNoParams() throws Exception {
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:2163", (String)"png", null, null);
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        File expected = new File(this.testRoot, "states/EPSG_2163_00/0_0/00_00.png");
        Assert.assertEquals((Object)expected, (Object)path);
    }

    @Test
    public void testPathWithParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", "population");
        TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:2163", (String)"png", params, null);
        String sha1 = DigestUtils.sha1Hex((String)"?style=population");
        File path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:2163", (String)"png", params, null);
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        this.testParameterId(path, sha1, "?style=population");
        params.put("style", "polygon");
        tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:2163", (String)"png", params, null);
        path = this.generator.tilePath(tile, (MimeType)ImageMime.png);
        sha1 = DigestUtils.sha1Hex((String)"?style=polygon");
        this.testParameterId(path, sha1, "?style=polygon");
    }

    private void testParameterId(File path, String parameterId, String parameterKvp) throws IOException {
        File expected = new File(this.testRoot, "states/EPSG_2163_00_" + parameterId + "/0_0/00_00.png");
        Assert.assertEquals((Object)expected.getPath(), (Object)path.getPath());
    }

    @Test
    public void testPathGeneratorFilterConsistency4326() throws GeoWebCacheException, IOException {
        GridSet gridSet4326 = new DefaultGridsets(true, true).worldEpsg4326();
        this.assertPathGeneratorFilterConsistency(gridSet4326);
    }

    @Test
    public void testPathGeneratorFilterConsistency3857() throws GeoWebCacheException, IOException {
        GridSet gridSet3857 = new DefaultGridsets(true, true).worldEpsg3857();
        this.assertPathGeneratorFilterConsistency(gridSet3857);
    }

    public void assertPathGeneratorFilterConsistency(GridSet gridSet4326) throws GeoWebCacheException, IOException {
        for (int z = 0; z < 5; ++z) {
            Grid grid = gridSet4326.getGrid(z);
            int y = 0;
            while ((long)y < grid.getNumTilesHigh()) {
                int x = 0;
                while ((long)x < grid.getNumTilesWide()) {
                    TileObject tile = TileObject.createCompleteTileObject((String)"states", (long[])new long[]{x, y, z}, (String)gridSet4326.getName(), (String)"png", null, null);
                    File file = this.generator.tilePath(tile, (MimeType)ImageMime.png);
                    if (!file.getParentFile().exists()) {
                        Assert.assertTrue((boolean)file.getParentFile().mkdirs());
                    }
                    Assert.assertTrue((boolean)file.createNewFile());
                    TileRange tr = new TileRange("states", gridSet4326.getName(), z, z, (long[][])new long[][]{{x, y, x, y, z}}, (MimeType)ImageMime.png, null);
                    DefaultFilePathFilter filter = new DefaultFilePathFilter(tr);
                    File gridsetFolder = file.getParentFile().getParentFile();
                    Assert.assertTrue((boolean)filter.accept(gridsetFolder.getParentFile(), gridsetFolder.getName()));
                    File intermediateFolder = file.getParentFile();
                    Assert.assertTrue((boolean)filter.accept(intermediateFolder.getParentFile(), gridsetFolder.getName()));
                    Assert.assertTrue((boolean)filter.accept(file.getParentFile(), file.getName()));
                    ++x;
                }
                ++y;
            }
        }
    }
}

