/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.file;

import java.io.File;
import java.io.IOException;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreSuitabilityTest;
import org.geowebcache.util.FileMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.experimental.theories.DataPoints;
import org.junit.rules.TemporaryFolder;

public abstract class FileBasedBlobStoreSuitabilityTest
extends BlobStoreSuitabilityTest {
    @ClassRule
    public static TemporaryFolder temp = new TemporaryFolder();

    @Override
    public abstract BlobStore create(Object var1) throws Exception;

    protected static File emptyDir() throws IOException {
        File emptyDir = temp.newFolder();
        return emptyDir;
    }

    protected static File newDir() throws IOException {
        File newDir = new File(FileBasedBlobStoreSuitabilityTest.emptyDir(), "new");
        return newDir;
    }

    protected static File dirWithFile() throws IOException {
        File dir = temp.newFolder();
        File someFile = new File(dir, "file");
        someFile.createNewFile();
        return dir;
    }

    protected static File dirWithDir() throws IOException {
        File dir = temp.newFolder();
        File someDir = new File(dir, "dir");
        someDir.mkdir();
        return dir;
    }

    protected static File withMetadata(File dir) throws IOException {
        new File(dir, "metadata.properties").createNewFile();
        return dir;
    }

    @DataPoints
    public static File[] persistenceLocations() throws Exception {
        return new File[]{FileBasedBlobStoreSuitabilityTest.newDir(), FileBasedBlobStoreSuitabilityTest.emptyDir(), FileBasedBlobStoreSuitabilityTest.withMetadata(FileBasedBlobStoreSuitabilityTest.emptyDir()), FileBasedBlobStoreSuitabilityTest.dirWithFile(), FileBasedBlobStoreSuitabilityTest.withMetadata(FileBasedBlobStoreSuitabilityTest.dirWithFile()), FileBasedBlobStoreSuitabilityTest.dirWithDir(), FileBasedBlobStoreSuitabilityTest.withMetadata(FileBasedBlobStoreSuitabilityTest.dirWithDir())};
    }

    @Override
    protected Matcher<Object> empty() {
        return Matchers.either(FileMatchers.directoryEmpty()).or(Matchers.not(FileMatchers.exists()));
    }

    @Override
    protected Matcher<Object> existing() {
        return FileMatchers.directoryContaining((Matcher<Iterable<File>>)Matchers.hasItem(FileMatchers.named("metadata.properties")));
    }
}

