/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.google.common.base.Preconditions;
import java.io.File;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class FileBlobStoreConfigTest {
    private FileBlobStoreInfo config;
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Rule
    public ExpectedException ex = ExpectedException.none();
    private TileLayerDispatcher layers;
    private LockProvider lockProvider;

    @Before
    public void before() {
        this.config = new FileBlobStoreInfo();
        this.layers = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.lockProvider = (LockProvider)Mockito.mock(LockProvider.class);
    }

    @Test
    public void testCreateInstanceNoId() throws StorageException {
        this.ex.expect(IllegalStateException.class);
        this.ex.expectMessage("id not set");
        this.config.createInstance(this.layers, this.lockProvider);
    }

    @Test
    public void testCreateInstanceNotEnabled() throws StorageException {
        this.config.setName("myblobstore");
        this.config.setEnabled(false);
        this.ex.expect(IllegalStateException.class);
        this.ex.expectMessage("store is not enabled");
        this.config.createInstance(this.layers, this.lockProvider);
    }

    @Test
    public void testCreateInstanceNoBaseDirectory() throws StorageException {
        this.config.setName("myblobstore");
        this.config.setEnabled(true);
        this.ex.expect(IllegalStateException.class);
        this.ex.expectMessage("baseDirectory not provided");
        this.config.createInstance(this.layers, this.lockProvider);
    }

    @Test
    public void testCreateInstanceIllegalBlockSize() throws StorageException {
        this.config.setName("myblobstore");
        this.config.setEnabled(true);
        this.config.setFileSystemBlockSize(-2048);
        this.config.setBaseDirectory(this.tmp.getRoot().getAbsolutePath());
        this.ex.expect(IllegalStateException.class);
        this.ex.expectMessage("must be a positive integer");
        this.config.createInstance(this.layers, this.lockProvider);
    }

    @Test
    public void testCreateInstance() throws StorageException {
        this.config.setName("myblobstore");
        this.config.setEnabled(true);
        File root = this.tmp.getRoot();
        Preconditions.checkState((root.exists() && root.isDirectory() ? 1 : 0) != 0);
        this.config.setBaseDirectory(root.getAbsolutePath());
        BlobStore store = this.config.createInstance(this.layers, this.lockProvider);
        Assert.assertNotNull((Object)store);
    }
}

