/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.GWCConfigIntegrationTestSupport;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;

public class GWCConfigIntegrationTestData {
    public static final String LAYER_TOPP_STATES = "topp:states";
    public static final String[] LAYERS = new String[]{"topp:states"};
    public static final String GRIDSET_EPSG2163 = "EPSG:2163";
    public static final String GRIDSET_EPSG4326 = "EPSG:4326";
    public static final String[] CUSTOM_GRIDSETS = new String[]{"EPSG:2163"};
    public static final String BLOBSTORE_FILE_DEFAULT = "defaultCache";
    public static final String[] BLOBSTORES = new String[]{"defaultCache"};

    public static void setUpTestData(GWCConfigIntegrationTestSupport testSupport) throws Exception {
        ServerConfiguration serverConfiguration = testSupport.getServerConfiguration();
        serverConfiguration.getServiceInformation().setTitle("GeoWebCache");
        GridSetConfiguration gridSetConfiguration = testSupport.getWritableGridSetConfiguration();
        GridSet epsg2163 = GridSetFactory.createGridSet((String)GRIDSET_EPSG2163, (SRS)SRS.getSRS((String)GRIDSET_EPSG2163), (BoundingBox)new BoundingBox(-2495667.977678598, -2223677.196231552, 3291070.6104286816, 959189.3312465074), (boolean)false, null, (double[])new double[]{2.5E7, 1000000.0, 100000.0, 25000.0}, null, (double)2.8E-4, null, (int)200, (int)200, (boolean)false);
        gridSetConfiguration.addGridSet(epsg2163);
        BlobStoreConfiguration blobStoreConfiguration = testSupport.getBlobStoreConfiguration();
        FileBlobStoreInfo blobStore = new FileBlobStoreInfo(BLOBSTORE_FILE_DEFAULT);
        blobStore.setEnabled(false);
        blobStore.setBaseDirectory("/tmp/defaultCache");
        blobStore.setFileSystemBlockSize(4096);
        blobStoreConfiguration.addBlobStore((BlobStoreInfo)blobStore);
        TileLayerConfiguration tileLayerConfiguration = testSupport.getTileLayerConfigurations().get(0);
        tileLayerConfiguration.setGridSetBroker(testSupport.getGridSetBroker());
        tileLayerConfiguration.afterPropertiesSet();
        HashMap<String, GridSubset> subSets = new HashMap<String, GridSubset>();
        subSets.put(GRIDSET_EPSG4326, GridSubsetFactory.createGridSubSet((GridSet)testSupport.getGridSetBroker().getWorldEpsg4326(), (BoundingBox)new BoundingBox(-129.6, 3.45, -62.1, 70.9), null, null));
        subSets.put(GRIDSET_EPSG2163, GridSubsetFactory.createGridSubSet((GridSet)epsg2163));
        StringParameterFilter parameterFilter = new StringParameterFilter();
        parameterFilter.setKey("STYLES");
        parameterFilter.setDefaultValue("population");
        parameterFilter.setValues(Arrays.asList("population", "polygon", "pophatch"));
        WMSLayer wmsLayer = new WMSLayer(LAYER_TOPP_STATES, new String[]{"http://demo.opengeo.org/geoserver/topp/wms"}, null, null, Arrays.asList("image/gif", "image/jpeg", "image/png", "image/png8"), subSets, Collections.singletonList(parameterFilter), null, null, true, null);
        wmsLayer.setBlobStoreId(blobStore.getName());
        tileLayerConfiguration.addLayer((TileLayer)wmsLayer);
    }
}

