/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GWCConfigIntegrationTestSupport;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;

public class GWCXMLConfigIntegrationTestSupport
extends GWCConfigIntegrationTestSupport {
    protected File configDir = Files.createTempDirectory("gwc", new FileAttribute[0]).toFile();
    protected File configFile = new File(this.configDir, "geowebcache.xml");
    protected XMLConfiguration config;

    public GWCXMLConfigIntegrationTestSupport() throws Exception {
        this.configDir.deleteOnExit();
        this.resetConfiguration();
    }

    @Override
    public void resetConfiguration() throws Exception {
        if (this.configFile != null) {
            URL source = XMLConfiguration.class.getResource("geowebcache-empty.xml");
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
        this.config = new XMLConfiguration(null, this.configDir.getAbsolutePath());
        this.broker = new GridSetBroker(this.getGridSetConfigurations());
        this.config.setGridSetBroker(this.broker);
        this.config.deinitialize();
        this.config.reinitialize();
    }

    @Override
    public List<TileLayerConfiguration> getTileLayerConfigurations() {
        return Collections.singletonList(this.config);
    }

    @Override
    public ServerConfiguration getServerConfiguration() {
        return this.config;
    }

    @Override
    public List<GridSetConfiguration> getGridSetConfigurations() {
        return Arrays.asList(new DefaultGridsets(true, true), this.config);
    }

    @Override
    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.config;
    }

    @Override
    public GridSetConfiguration getWritableGridSetConfiguration() {
        return this.config;
    }
}

