/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.geowebcache.config.ConfigurationTest;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class GridSetConfigurationTest
extends ConfigurationTest<GridSet, GridSetConfiguration> {
    @Test
    public void testCanSaveGoodInfo() throws Exception {
        Assert.assertThat((Object)((GridSetConfiguration)this.config).canSave(this.getGoodInfo("test", 1)), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCanSaveBadInfo() throws Exception {
        Assert.assertThat((Object)((GridSetConfiguration)this.config).canSave(this.getBadInfo("test", 1)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Override
    protected void addInfo(GridSetConfiguration config, GridSet info) throws Exception {
        config.addGridSet(info);
    }

    @Override
    protected Optional<GridSet> getInfo(GridSetConfiguration config, String name) throws Exception {
        return config.getGridSet(name);
    }

    @Override
    protected Collection<? extends GridSet> getInfos(GridSetConfiguration config) throws Exception {
        return config.getGridSets();
    }

    @Override
    protected Set<String> getInfoNames(GridSetConfiguration config) throws Exception {
        return config.getGridSetNames();
    }

    @Override
    protected void removeInfo(GridSetConfiguration config, String name) throws Exception {
        config.removeGridSet(name);
    }

    @Override
    protected void renameInfo(GridSetConfiguration config, String name1, String name2) throws Exception {
        config.renameGridSet(name1, name2);
    }

    @Override
    protected void modifyInfo(GridSetConfiguration config, GridSet info) throws Exception {
        config.modifyGridSet(info);
    }

    @Override
    protected GridSet getGoodInfo(String id, int rand) {
        GridSet gridset = GridSetFactory.createGridSet((String)id, (SRS)SRS.getSRS((int)4326), (BoundingBox)new BoundingBox(0.0, 0.0, 1.0, 1.0), (boolean)true, (int)3, (Double)1.0, (double)2.8E-4, (int)256, (int)256, (boolean)false);
        gridset.setDescription(Integer.toString(rand));
        return gridset;
    }

    @Override
    protected GridSet getBadInfo(String id, int rand) {
        return new GridSet(){};
    }

    @Override
    protected void doModifyInfo(GridSet info, int rand) throws Exception {
        info.setDescription(Integer.toString(rand));
    }
}

