/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.web.context.WebApplicationContext;

public class ServerConfigurationTest {
    private static final String VERSION_PATTERN = "1(\\.\\d+)+(\\-\\w+)*";
    ServerConfiguration config;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File configDir;
    private File configFile;
    private GridSetBroker gridSetBroker;

    @Test
    public void serverConfigTest() throws Exception {
        this.config = this.getConfig();
        ServiceInformation serviceInfo = this.config.getServiceInformation();
        Assert.assertEquals((Object)"GeoWebCache", (Object)serviceInfo.getTitle());
        Assert.assertEquals((Object)"John Smith inc.", (Object)serviceInfo.getServiceProvider().getProviderName());
        ServiceInformation newinfo = new ServiceInformation();
        newinfo.setProviderName("John Adams inc.");
        this.config.setServiceInformation(newinfo);
        Assert.assertEquals((Object)"John Adams inc.", (Object)this.config.getServiceInformation().getProviderName());
        Boolean runtimeStats = this.config.isRuntimeStatsEnabled();
        Assert.assertTrue((boolean)runtimeStats);
        this.config.setRuntimeStatsEnabled(Boolean.valueOf(false));
        runtimeStats = this.config.isRuntimeStatsEnabled();
        Assert.assertFalse((boolean)runtimeStats);
        LockProvider lockProvider = this.config.getLockProvider();
        Assert.assertNotNull((Object)lockProvider);
        Boolean fullWMS = this.config.isFullWMS();
        Assert.assertNull((Object)fullWMS);
        this.config.setFullWMS(Boolean.valueOf(true));
        fullWMS = this.config.isFullWMS();
        Assert.assertTrue((boolean)fullWMS);
        Boolean wmtsCiteCompliant = this.config.isWmtsCiteCompliant();
        Assert.assertFalse((boolean)wmtsCiteCompliant);
        this.config.setWmtsCiteCompliant(Boolean.valueOf(true));
        wmtsCiteCompliant = this.config.isWmtsCiteCompliant();
        Assert.assertTrue((boolean)wmtsCiteCompliant);
        Boolean cacheBypassAllowed = this.config.isCacheBypassAllowed();
        Assert.assertNull((Object)cacheBypassAllowed);
        this.config.setCacheBypassAllowed(Boolean.valueOf(true));
        cacheBypassAllowed = this.config.isCacheBypassAllowed();
        Assert.assertTrue((boolean)cacheBypassAllowed);
        Integer backendTimeout = this.config.getBackendTimeout();
        Assert.assertEquals((Object)backendTimeout, (Object)120);
        this.config.setBackendTimeout(Integer.valueOf(60));
        backendTimeout = this.config.getBackendTimeout();
        Assert.assertEquals((Object)backendTimeout, (Object)60);
        Assert.assertThat((Object)this.config, (Matcher)Matchers.hasProperty((String)"version", TestUtils.matchesRegex(VERSION_PATTERN)));
        this.config.afterPropertiesSet();
        ServiceInformation savedInfo = this.config.getServiceInformation();
        Assert.assertEquals((Object)savedInfo.getProviderName(), (Object)"John Adams inc.");
        Assert.assertFalse((boolean)this.config.isRuntimeStatsEnabled());
        Assert.assertTrue((boolean)this.config.isFullWMS());
        Assert.assertTrue((boolean)this.config.isWmtsCiteCompliant());
        Assert.assertTrue((boolean)this.config.isCacheBypassAllowed());
        Assert.assertEquals((Object)this.config.getBackendTimeout(), (Object)60);
        Assert.assertThat((Object)this.config.getVersion(), TestUtils.matchesRegex(VERSION_PATTERN));
    }

    protected ServerConfiguration getConfig() throws Exception {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            URL source = XMLConfiguration.class.getResource("geowebcache_190.xml");
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
        this.gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        XMLFileResourceProvider configProvider = new XMLFileResourceProvider("geowebcache.xml", (WebApplicationContext)null, this.configDir.getAbsolutePath(), null);
        this.config = new XMLConfiguration(null, (ConfigurationResourceProvider)configProvider);
        ((XMLConfiguration)this.config).setGridSetBroker(this.gridSetBroker);
        this.config.afterPropertiesSet();
        return this.config;
    }
}

