/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreConfigurationTest;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.TestXMLConfigurationSource;
import org.geowebcache.config.XMLConfiguration;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class XMLConfigurationBlobStoreConformanceTest
extends BlobStoreConfigurationTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File configDir;
    private File configFile;
    @Rule
    public MockWepAppContextRule extensions = new MockWepAppContextRule();
    @Rule
    public MockWepAppContextRule extensions2 = new MockWepAppContextRule(false);
    TestXMLConfigurationSource configSource = new TestXMLConfigurationSource();

    @Override
    public void failNextRead() {
        this.configSource.setFailNextRead(true);
    }

    @Override
    public void failNextWrite() {
        this.configSource.setFailNextWrite(true);
    }

    @Override
    protected BlobStoreConfiguration getConfig() throws Exception {
        this.makeConfigFile();
        return this.getConfig(this.extensions);
    }

    protected void makeConfigFile() throws IOException {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            URL source = XMLConfiguration.class.getResource("geowebcache_190.xml");
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
    }

    @Override
    protected BlobStoreConfiguration getSecondConfig() throws Exception {
        return this.getConfig(this.extensions2);
    }

    protected BlobStoreConfiguration getConfig(MockWepAppContextRule extensions) throws Exception {
        return this.configSource.create(extensions, this.configDir);
    }

    @Test
    public void testBlobStoreConfigIsLoaded() throws Exception {
        List blobStores = ((BlobStoreConfiguration)this.config).getBlobStores();
        Assert.assertEquals((String)"Unexpected number of BlobStoreInfo elements configured", (long)1L, (long)blobStores.size());
        BlobStoreInfo info = (BlobStoreInfo)blobStores.get(0);
        Assert.assertFalse((String)"Unexpected BlobStoreInfo default setting", (boolean)info.isDefault());
        Assert.assertFalse((String)"Unexpected BlobStoreInfo enabled setting", (boolean)info.isEnabled());
        Assert.assertTrue((String)"Unexpected BlobeStoreInfo class type", (boolean)FileBlobStoreInfo.class.isAssignableFrom(info.getClass()));
        FileBlobStoreInfo fileInfo = (FileBlobStoreInfo)FileBlobStoreInfo.class.cast(info);
        Assert.assertEquals((String)"Unexpected FileBlobStoreInfo filesystem block size", (long)4096L, (long)fileInfo.getFileSystemBlockSize());
        Assert.assertEquals((String)"Unexpected FileBlobStoreInfo location value", (Object)"/tmp/defaultCache", (Object)fileInfo.getBaseDirectory());
    }

    @Override
    protected void doModifyInfo(BlobStoreInfo info, int rand) throws Exception {
        ((FileBlobStoreInfo)info).setFileSystemBlockSize(rand);
    }

    @Override
    protected BlobStoreInfo getGoodInfo(String id, int rand) throws Exception {
        FileBlobStoreInfo info = new FileBlobStoreInfo(id);
        info.setEnabled(false);
        info.setDefault(false);
        info.setBaseDirectory("/tmp/defaultCache");
        info.setFileSystemBlockSize(rand);
        return info;
    }

    @Override
    protected BlobStoreInfo getBadInfo(String id, int rand) throws Exception {
        FileBlobStoreInfo info = new FileBlobStoreInfo(id){

            public String getName() {
                return null;
            }
        };
        return info;
    }

    @Override
    protected String getExistingInfo() {
        return "defaultCache";
    }

    @Override
    protected Matcher<BlobStoreInfo> infoEquals(final BlobStoreInfo expected) {
        return new CustomMatcher<BlobStoreInfo>("BlobStoreInfo Matcher"){

            public boolean matches(Object item) {
                return expected.equals(item);
            }
        };
    }

    @Override
    protected Matcher<BlobStoreInfo> infoEquals(final int expected) {
        return new CustomMatcher<BlobStoreInfo>("BlobStoreInfo with value " + expected){

            public boolean matches(Object item) {
                return item instanceof FileBlobStoreInfo && Objects.equals(((FileBlobStoreInfo)item).getFileSystemBlockSize(), expected);
            }
        };
    }
}

