/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.LayerConfigurationTest;
import org.geowebcache.config.TestXMLConfigurationSource;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.AbstractTileLayer;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.util.TestUtils;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class XMLConfigurationLayerConformanceTest
extends LayerConfigurationTest {
    @Rule
    public MockWepAppContextRule extensions = new MockWepAppContextRule();
    @Rule
    public MockWepAppContextRule extensions2 = new MockWepAppContextRule(false);
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected File configDir;
    protected File configFile;
    TestXMLConfigurationSource configSource = new TestXMLConfigurationSource();

    @Override
    protected TileLayer getGoodInfo(String id, int rand) {
        WMSLayer layer = new WMSLayer(id, new String[]{"http://example.com/"}, null, Integer.toString(rand), null, null, null, null, null, false, null);
        return layer;
    }

    @Override
    protected TileLayer getBadInfo(final String id, int rand) {
        return new AbstractTileLayer(){
            {
                this.name = id;
            }

            protected boolean initializeInternal(GridSetBroker gridSetBroker) {
                return false;
            }

            public String getStyles() {
                return null;
            }

            public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
                return null;
            }

            public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
                return null;
            }

            public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
            }

            public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
                return null;
            }
        };
    }

    @Override
    protected TileLayerConfiguration getConfig() throws Exception {
        this.makeConfigFile();
        return this.getConfig(this.extensions);
    }

    @Override
    protected TileLayerConfiguration getSecondConfig() throws Exception {
        return this.getConfig(this.extensions2);
    }

    protected TileLayerConfiguration getConfig(MockWepAppContextRule extensions) throws Exception {
        return this.configSource.create(extensions, this.configDir);
    }

    protected void makeConfigFile() throws Exception {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            URL source = XMLConfiguration.class.getResource("geowebcache_1120.xml");
            FileUtils.copyURLToFile((URL)source, (File)this.configFile);
        }
    }

    @Override
    protected Matcher<TileLayer> infoEquals(final TileLayer expected) {
        return new CustomMatcher<TileLayer>("Layer matching " + expected.getId() + " with " + ((WMSLayer)expected).getWmsLayers()){

            public boolean matches(Object item) {
                return item instanceof WMSLayer && ((WMSLayer)item).getId().equals(expected.getId()) && ((WMSLayer)item).getWmsLayers().equals(((WMSLayer)expected).getWmsLayers());
            }
        };
    }

    @Override
    protected Matcher<TileLayer> infoEquals(final int expected) {
        return new CustomMatcher<TileLayer>("Layer with value" + expected){

            public boolean matches(Object item) {
                return item instanceof WMSLayer && ((WMSLayer)item).getWmsLayers().equals(expected);
            }
        };
    }

    @Override
    protected String getExistingInfo() {
        return "topp:states";
    }

    @Override
    public void failNextRead() {
        this.configSource.setFailNextRead(true);
    }

    @Override
    public void failNextWrite() {
        this.configSource.setFailNextWrite(true);
    }

    @Override
    protected void renameInfo(TileLayerConfiguration config, String name1, String name2) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    @Override
    protected void doModifyInfo(TileLayer info, int rand) throws Exception {
        ((WMSLayer)info).setWmsLayers(Integer.toString(rand));
    }

    @Override
    @Ignore
    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfo() throws Exception {
        super.testModifyCallRequiredToChangeInfoFromGetInfo();
    }

    @Override
    @Ignore
    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfos() throws Exception {
        super.testModifyCallRequiredToChangeInfoFromGetInfos();
    }

    @Override
    @Ignore
    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfo() throws Exception {
        super.testModifyCallRequiredToChangeExistingInfoFromGetInfo();
    }

    @Override
    @Ignore
    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfos() throws Exception {
        super.testModifyCallRequiredToChangeExistingInfoFromGetInfos();
    }

    @Test
    public void testGetExistingHasGridset() throws Exception {
        Optional<TileLayer> retrieved = this.getInfo((TileLayerConfiguration)this.config, this.getExistingInfo());
        Assert.assertThat(retrieved, TestUtils.isPresent(Matchers.hasProperty((String)"gridSubsets", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"EPSG:4326", "EPSG:2163"}))));
    }
}

