/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.legends;

import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.config.legends.LegendInfoBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LegendInfoBuilderTest {
    @Test
    public void testWithOnlyDefaults() {
        LegendInfo legendInfo = new LegendInfoBuilder().withLayerName("layer1").withLayerUrl("http://localhost:8080/geoserver").withDefaultWidth(Integer.valueOf(50)).withDefaultHeight(Integer.valueOf(100)).withDefaultFormat("image/png").build();
        Assert.assertThat((Object)legendInfo.getWidth(), (Matcher)Matchers.is((Object)50));
        Assert.assertThat((Object)legendInfo.getHeight(), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)legendInfo.getFormat(), (Matcher)Matchers.is((Object)"image/png"));
        Assert.assertThat((Object)legendInfo.getStyleName(), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)legendInfo.getMinScale(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)legendInfo.getMaxScale(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)legendInfo.getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver?service=WMS&request=GetLegendGraphic&format=image/png&width=50&height=100&layer=layer1&style="));
    }

    @Test
    public void testWithValues() {
        LegendInfo legendInfo = new LegendInfoBuilder().withLayerName("layer1").withLayerUrl("http://localhost:8080/geoserver").withDefaultWidth(Integer.valueOf(50)).withDefaultHeight(Integer.valueOf(100)).withDefaultFormat("image/png").withStyleName("style1").withWidth(Integer.valueOf(150)).withHeight(Integer.valueOf(200)).withFormat("image/gif").withMinScale(Double.valueOf(1000.55)).withMaxScale(Double.valueOf(2000.655)).build();
        Assert.assertThat((Object)legendInfo.getWidth(), (Matcher)Matchers.is((Object)150));
        Assert.assertThat((Object)legendInfo.getHeight(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)legendInfo.getFormat(), (Matcher)Matchers.is((Object)"image/gif"));
        Assert.assertThat((Object)legendInfo.getStyleName(), (Matcher)Matchers.is((Object)"style1"));
        Assert.assertThat((Object)legendInfo.getMinScale(), (Matcher)Matchers.is((Object)1000.55));
        Assert.assertThat((Object)legendInfo.getMaxScale(), (Matcher)Matchers.is((Object)2000.655));
        Assert.assertThat((Object)legendInfo.getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver?service=WMS&request=GetLegendGraphic&format=image/gif&width=150&height=200&layer=layer1&style=style1"));
    }

    @Test
    public void testWithUrl() {
        LegendInfo legendInfo = new LegendInfoBuilder().withLayerName("layer1").withLayerUrl("http://localhost:8080/geoserver").withDefaultWidth(Integer.valueOf(50)).withDefaultHeight(Integer.valueOf(100)).withDefaultFormat("image/png").withStyleName("style1").withWidth(Integer.valueOf(150)).withHeight(Integer.valueOf(200)).withFormat("image/gif").withUrl("http://localhost:9090/image.gif?").build();
        Assert.assertThat((Object)legendInfo.getWidth(), (Matcher)Matchers.is((Object)150));
        Assert.assertThat((Object)legendInfo.getHeight(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)legendInfo.getFormat(), (Matcher)Matchers.is((Object)"image/gif"));
        Assert.assertThat((Object)legendInfo.getStyleName(), (Matcher)Matchers.is((Object)"style1"));
        Assert.assertThat((Object)legendInfo.getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:9090/image.gif?service=WMS&request=GetLegendGraphic&format=image/gif&width=150&height=200&layer=layer1&style=style1"));
    }

    @Test
    public void testWithCompleteUrl() {
        LegendInfo legendInfo = new LegendInfoBuilder().withLayerName("layer1").withLayerUrl("http://localhost:8080/geoserver").withDefaultWidth(Integer.valueOf(50)).withDefaultHeight(Integer.valueOf(100)).withDefaultFormat("image/png").withStyleName("style1").withWidth(Integer.valueOf(150)).withHeight(Integer.valueOf(200)).withFormat("image/gif").withCompleteUrl("http://my.server.com/image.gif").build();
        Assert.assertThat((Object)legendInfo.getWidth(), (Matcher)Matchers.is((Object)150));
        Assert.assertThat((Object)legendInfo.getHeight(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)legendInfo.getFormat(), (Matcher)Matchers.is((Object)"image/gif"));
        Assert.assertThat((Object)legendInfo.getStyleName(), (Matcher)Matchers.is((Object)"style1"));
        Assert.assertThat((Object)legendInfo.getLegendUrl(), (Matcher)Matchers.is((Object)"http://my.server.com/image.gif"));
    }

    @Test
    public void testWithValuesNoDefaults() {
        LegendInfo legendInfo = new LegendInfoBuilder().withLayerName("layer1").withLayerUrl("http://localhost:8080/geoserver").withStyleName("style1").withWidth(Integer.valueOf(150)).withHeight(Integer.valueOf(200)).withFormat("image/gif").withMinScale(Double.valueOf(50.5)).withMaxScale(Double.valueOf(80.5)).build();
        Assert.assertThat((Object)legendInfo.getWidth(), (Matcher)Matchers.is((Object)150));
        Assert.assertThat((Object)legendInfo.getHeight(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)legendInfo.getFormat(), (Matcher)Matchers.is((Object)"image/gif"));
        Assert.assertThat((Object)legendInfo.getStyleName(), (Matcher)Matchers.is((Object)"style1"));
        Assert.assertThat((Object)legendInfo.getMinScale(), (Matcher)Matchers.is((Object)50.5));
        Assert.assertThat((Object)legendInfo.getMaxScale(), (Matcher)Matchers.is((Object)80.5));
        Assert.assertThat((Object)legendInfo.getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver?service=WMS&request=GetLegendGraphic&format=image/gif&width=150&height=200&layer=layer1&style=style1"));
    }
}

