/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.thoughtworks.xstream.XStream;
import java.util.Arrays;
import org.custommonkey.xmlunit.XMLAssert;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.io.GeoWebCacheXStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class FloatParameterFilterTest {
    private FloatParameterFilter filter;
    private XStream xs;

    @Before
    public void setUp() {
        this.filter = new FloatParameterFilter();
        this.filter.setKey("TEST");
        this.filter.setValues(Arrays.asList(Float.valueOf(42.0f), Float.valueOf(6.283f), Float.valueOf(-17.5f)));
        this.filter.setDefaultValue("Default");
        this.filter.setThreshold(Float.valueOf(1.0E-5f));
        this.xs = new GeoWebCacheXStream();
        this.xs = XMLConfiguration.getConfiguredXStream((XStream)this.xs, (WebApplicationContext)new StaticWebApplicationContext());
    }

    @Test
    public void testBasic() throws Exception {
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"42.0", "6.283", "-17.5"}));
        for (String test : Arrays.asList("42.0", "6.283", "-17.5", "42", "6.2830", "-1.75e1")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
        }
        for (String test : Arrays.asList("42.0", "42", "4.2e1")) {
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"42.0"));
        }
        for (String test : Arrays.asList("42.5", "6.281", "-17.52", "-42.0", "-6.283", "17.5")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testThreshold() throws Exception {
        this.filter.setThreshold(Float.valueOf(15.0f));
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"42.0", "6.283", "-17.5"}));
        for (String test : Arrays.asList("42.0", "6.283", "-17.5", "42", "6.2830", "-1.75e1")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should apply to %0", (Matcher)Matchers.is((Object)true), (Object[])new Object[]{test}));
        }
        for (String test : Arrays.asList("42", "56.99999", "27.00001")) {
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"42.0"));
        }
        for (String test : Arrays.asList("6.283", Float.toString(21.282991f), Float.toString(-5.608499f))) {
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"6.283"));
        }
        for (String test : Arrays.asList("-17.5", Float.toString(-32.49999f), Float.toString(-5.608501f))) {
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)"-17.5"));
        }
        for (String test : Arrays.asList("57", "27", "-42")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.describedAs((String)"Filter should not apply to %0", (Matcher)Matchers.is((Object)false), (Object[])new Object[]{test}));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testToXML() throws Exception {
        XMLAssert.assertXMLEqual((String)"<floatParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <float>42.0</float>\n    <float>6.283</float>\n    <float>-17.5</float>\n  </values>\n  <threshold>1.0E-5</threshold>\n</floatParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testFromXML() throws Exception {
        Object o = this.xs.fromXML("<floatParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <float>42</float>\n    <float>6.283</float>\n    <float>-17.5</float>\n  </values>\n  <threshold>0.00001</threshold>\n</floatParameterFilter>");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(FloatParameterFilter.class));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)"TEST")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"defaultValue", (Matcher)Matchers.equalTo((Object)"Default")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"threshold", (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0E-5f))));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"values", (Matcher)Matchers.containsInAnyOrder((Object[])new Float[]{Float.valueOf(42.0f), Float.valueOf(6.283f), Float.valueOf(-17.5f)})));
    }

    @Test
    public void testCloneable() throws Exception {
        FloatParameterFilter clone = this.filter.clone();
        Assert.assertThat((Object)clone.getDefaultValue(), (Matcher)Matchers.equalTo((Object)this.filter.getDefaultValue()));
        Assert.assertThat((Object)clone.getValues(), (Matcher)Matchers.equalTo((Object)this.filter.getValues()));
    }
}

