/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;
import org.junit.Test;

public class ParametersUtilsTest {
    @Test
    public void testEmptyToKVP() {
        String result = ParametersUtils.getKvp(Collections.emptyMap());
        Assert.assertThat((Object)result, (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void testEmptyToMap() {
        Map result = ParametersUtils.getMap((String)"");
        Assert.assertThat(result.entrySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void testSingletonToKVP() {
        String result = ParametersUtils.getKvp(Collections.singletonMap("test", "blah"));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"test=blah"));
    }

    @Test
    public void testSingletonToMap() {
        Map result = ParametersUtils.getMap((String)"test=blah");
        Assert.assertThat((Object)result, ParametersUtilsTest.hasEntries(ParametersUtilsTest.entry(Matchers.equalTo((Object)"test"), Matchers.equalTo((Object)"blah"))));
    }

    @Test
    public void testTwoToKVP() {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("test1", "blah1");
        parameters.put("test2", "blah2");
        String result = ParametersUtils.getKvp(parameters);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"test1=blah1&test2=blah2"));
    }

    @Test
    public void testTwoToMap() {
        Map result = ParametersUtils.getMap((String)"test1=blah1&test2=blah2");
        Assert.assertThat((Object)result, ParametersUtilsTest.hasEntries(ParametersUtilsTest.entry(Matchers.equalTo((Object)"test1"), Matchers.equalTo((Object)"blah1")), ParametersUtilsTest.entry(Matchers.equalTo((Object)"test2"), Matchers.equalTo((Object)"blah2"))));
    }

    @Test
    public void testTwoToKVPSorting() {
        TreeMap<String, String> parameters = new TreeMap<String, String>((s1, s2) -> -s1.compareTo((String)s2));
        parameters.put("test1", "blah1");
        parameters.put("test2", "blah2");
        String result = ParametersUtils.getKvp(parameters);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"test1=blah1&test2=blah2"));
    }

    @Test
    public void testEqualsToKVP() {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("=test1", "=blah1");
        parameters.put("te=st2", "bl=ah2");
        parameters.put("test3=", "blah3=");
        String result = ParametersUtils.getKvp(parameters);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"%3Dtest1=%3Dblah1&te%3Dst2=bl%3Dah2&test3%3D=blah3%3D"));
    }

    @Test
    public void testEqualsToMap() {
        Map result = ParametersUtils.getMap((String)"%3Dtest1=%3Dblah1&te%3Dst2=bl%3Dah2&test3%3D=blah3%3D");
        Assert.assertThat((Object)result, ParametersUtilsTest.hasEntries(ParametersUtilsTest.entry(Matchers.equalTo((Object)"=test1"), Matchers.equalTo((Object)"=blah1")), ParametersUtilsTest.entry(Matchers.equalTo((Object)"te=st2"), Matchers.equalTo((Object)"bl=ah2")), ParametersUtilsTest.entry(Matchers.equalTo((Object)"test3="), Matchers.equalTo((Object)"blah3="))));
    }

    @Test
    public void testAmpToKVP() {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("&test1", "&blah1");
        parameters.put("te&st2", "bl&ah2");
        parameters.put("test3&", "blah3&");
        String result = ParametersUtils.getKvp(parameters);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)"%26test1=%26blah1&te%26st2=bl%26ah2&test3%26=blah3%26"));
    }

    @Test
    public void testAmpToMap() {
        Map result = ParametersUtils.getMap((String)"%26test1=%26blah1&te%26st2=bl%26ah2&test3%26=blah3%26");
        Assert.assertThat((Object)result, ParametersUtilsTest.hasEntries(ParametersUtilsTest.entry(Matchers.equalTo((Object)"&test1"), Matchers.equalTo((Object)"&blah1")), ParametersUtilsTest.entry(Matchers.equalTo((Object)"te&st2"), Matchers.equalTo((Object)"bl&ah2")), ParametersUtilsTest.entry(Matchers.equalTo((Object)"test3&"), Matchers.equalTo((Object)"blah3&"))));
    }

    @SafeVarargs
    static <K, V> Matcher<Map<K, V>> hasEntries(Matcher<Map.Entry<K, V>> ... entryMatchers) {
        final Matcher entrySetMatcher = Matchers.containsInAnyOrder(entryMatchers);
        return new BaseMatcher<Map<K, V>>(){

            public boolean matches(Object item) {
                if (item instanceof Map) {
                    return entrySetMatcher.matches(((Map)item).entrySet());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("has entries ");
                description.appendDescriptionOf((SelfDescribing)entrySetMatcher);
            }
        };
    }

    static <K, V> Matcher<Map.Entry<K, V>> entry(Matcher<K> key, Matcher<V> value) {
        return Matchers.allOf((Matcher)Matchers.instanceOf(Map.Entry.class), (Matcher)Matchers.hasProperty((String)"key", key), (Matcher)Matchers.hasProperty((String)"value", value));
    }
}

