/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.thoughtworks.xstream.XStream;
import java.util.Arrays;
import java.util.Locale;
import org.custommonkey.xmlunit.XMLAssert;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.io.GeoWebCacheXStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class StringParameterFilterTest {
    private StringParameterFilter filter;
    private XStream xs;

    @Before
    public void setUp() {
        this.filter = new StringParameterFilter();
        this.filter.setKey("TEST");
        this.filter.setValues(Arrays.asList("foo", "Bar", "BAZ"));
        this.filter.setDefaultValue("Default");
        this.xs = new GeoWebCacheXStream();
        this.xs = XMLConfiguration.getConfiguredXStream((XStream)this.xs, (WebApplicationContext)new StaticWebApplicationContext());
    }

    @Test
    public void testBasic() throws Exception {
        Assert.assertThat((Object)this.filter.getNormalize(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"case", (Matcher)Matchers.equalTo((Object)CaseNormalizer.Case.NONE)), (Matcher)Matchers.hasProperty((String)"locale", (Matcher)Matchers.equalTo((Object)Locale.getDefault()))));
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "Bar", "BAZ"}));
        for (String test : Arrays.asList("foo", "Bar", "BAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test));
        }
        for (String test : Arrays.asList("Foo", "FOO", "BaR", "bar", "BAR", "BAz", "baz")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        for (String test : Arrays.asList("fooo", "fo", "Ba", "BBarr", "BA", "BBAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testNormalizeUpper() throws Exception {
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.UPPER, Locale.ENGLISH));
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"FOO", "BAR", "BAZ"}));
        for (String test : Arrays.asList("foo", "Bar", "BAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toUpperCase(Locale.ENGLISH)));
        }
        for (String test : Arrays.asList("Foo", "FOO", "BaR", "bar", "BAR", "BAz", "baz")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toUpperCase(Locale.ENGLISH)));
        }
        for (String test : Arrays.asList("fooo", "fo", "Ba", "BBarr", "BA", "BBAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testNormalizeLower() throws Exception {
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.LOWER, Locale.ENGLISH));
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar", "baz"}));
        for (String test : Arrays.asList("foo", "Bar", "BAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toLowerCase(Locale.ENGLISH)));
        }
        for (String test : Arrays.asList("Foo", "FOO", "BaR", "bar", "BAR", "BAz", "baz")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toLowerCase(Locale.ENGLISH)));
        }
        for (String test : Arrays.asList("fooo", "fo", "Ba", "BBarr", "BA", "BBAZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testNormalizeLocale() throws Exception {
        this.filter.setValues(Arrays.asList("f\u0131o", "B\u0131r", "BIZ"));
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.LOWER, Locale.forLanguageTag("tr")));
        Assert.assertThat((Object)this.filter.getLegalValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"f\u0131o", "b\u0131r", "b\u0131z"}));
        for (String test : Arrays.asList("f\u0131o", "B\u0131r", "BIZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toLowerCase(Locale.forLanguageTag("tr"))));
        }
        for (String test : Arrays.asList("F\u0131o", "FIO", "B\u0131R", "b\u0131r", "BIR", "BIz", "b\u0131z")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)this.filter.apply(test), (Matcher)Matchers.equalTo((Object)test.toLowerCase(Locale.forLanguageTag("tr"))));
        }
        for (String test : Arrays.asList("f\u0131oo", "f\u0131", "B\u0131", "BB\u0131rr", "BI", "BBIZ")) {
            Assert.assertThat((Object)this.filter.applies(test), (Matcher)Matchers.is((Object)false));
            try {
                this.filter.apply(test);
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(ParameterException.class));
            }
        }
        Assert.assertThat((Object)this.filter.apply(null), (Matcher)Matchers.equalTo((Object)"Default"));
        Assert.assertThat((Object)this.filter.apply(""), (Matcher)Matchers.equalTo((Object)"Default"));
    }

    @Test
    public void testToXMLNullNormalizer() throws Exception {
        XMLAssert.assertXMLEqual((String)"<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testToXMLDefaultNormalizer() throws Exception {
        this.filter.setNormalize(new CaseNormalizer());
        XMLAssert.assertXMLEqual((String)"<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <normalize/>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testToXMLNoneNormalizer() throws Exception {
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.NONE));
        XMLAssert.assertXMLEqual((String)"<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <normalize>\n    <case>NONE</case>\n  </normalize>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testToXMLUpperCanadianEnglish() throws Exception {
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.UPPER, Locale.CANADA));
        XMLAssert.assertXMLEqual((String)"<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <normalize>\n    <case>UPPER</case>\n    <locale>en_CA</locale>\n  </normalize>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>", (String)this.xs.toXML((Object)this.filter));
    }

    @Test
    public void testFromXMLUpperCanadianEnglish() throws Exception {
        Object o = this.xs.fromXML("<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <normalize>\n    <case>UPPER</case>\n    <locale>en_CA</locale>\n  </normalize>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(StringParameterFilter.class));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)"TEST")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"defaultValue", (Matcher)Matchers.equalTo((Object)"Default")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"normalize", (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(CaseNormalizer.class), (Matcher)Matchers.hasProperty((String)"case", (Matcher)Matchers.is((Object)CaseNormalizer.Case.UPPER)), (Matcher)Matchers.hasProperty((String)"locale", (Matcher)Matchers.is((Object)Locale.CANADA)))));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"values", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "Bar", "BAZ"})));
    }

    @Test
    public void testFromXMLIdentifiersCaseInsensitive() throws Exception {
        Object o = this.xs.fromXML("<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <normalize>\n    <case>uPPer</case>\n    <locale>EN_ca</locale>\n  </normalize>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(StringParameterFilter.class));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)"TEST")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"defaultValue", (Matcher)Matchers.equalTo((Object)"Default")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"normalize", (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(CaseNormalizer.class), (Matcher)Matchers.hasProperty((String)"case", (Matcher)Matchers.is((Object)CaseNormalizer.Case.UPPER)), (Matcher)Matchers.hasProperty((String)"locale", (Matcher)Matchers.is((Object)Locale.CANADA)))));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"values", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "Bar", "BAZ"})));
    }

    @Test
    public void testFromXMLDefaultNormalize() throws Exception {
        Object o = this.xs.fromXML("<stringParameterFilter>\n  <key>TEST</key>\n  <defaultValue>Default</defaultValue>\n  <values>\n    <string>foo</string>\n    <string>Bar</string>\n    <string>BAZ</string>\n  </values>\n</stringParameterFilter>");
        Assert.assertThat((Object)o, (Matcher)Matchers.instanceOf(StringParameterFilter.class));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.equalTo((Object)"TEST")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"defaultValue", (Matcher)Matchers.equalTo((Object)"Default")));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"normalize", (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(CaseNormalizer.class), (Matcher)Matchers.hasProperty((String)"case", (Matcher)Matchers.is((Object)CaseNormalizer.Case.NONE)))));
        Assert.assertThat((Object)o, (Matcher)Matchers.hasProperty((String)"values", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "Bar", "BAZ"})));
    }

    @Test
    public void testCloneable() throws Exception {
        StringParameterFilter clone = this.filter.clone();
        Assert.assertThat((Object)clone.getDefaultValue(), (Matcher)Matchers.equalTo((Object)this.filter.getDefaultValue()));
        Assert.assertThat((Object)clone.getValues(), (Matcher)Matchers.equalTo((Object)this.filter.getValues()));
        Assert.assertThat((Object)clone.normalize, (Matcher)Matchers.equalTo((Object)this.filter.normalize));
        this.filter.setNormalize(new CaseNormalizer(CaseNormalizer.Case.UPPER, Locale.ENGLISH));
        clone = this.filter.clone();
        Assert.assertThat((Object)clone.getDefaultValue(), (Matcher)Matchers.equalTo((Object)this.filter.getDefaultValue()));
        Assert.assertThat((Object)clone.getValues(), (Matcher)Matchers.equalTo((Object)this.filter.getValues()));
        Assert.assertThat((Object)clone.normalize, (Matcher)Matchers.equalTo((Object)this.filter.normalize));
    }
}

