/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.security;

import org.easymock.EasyMock;
import org.geowebcache.MockExtensionRule;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.filter.security.SecurityFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SecurityDispatcherTest {
    @Rule
    public MockExtensionRule extensions = new MockExtensionRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testOneFilterPass() throws Exception {
        SecurityDispatcher secDispatcher = new SecurityDispatcher();
        secDispatcher.setApplicationContext(this.extensions.getMockContext());
        ConveyorTile conv = (ConveyorTile)EasyMock.createMock((String)"conv", ConveyorTile.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)EasyMock.createMock((String)"subset", GridSubset.class);
        SRS srs = (SRS)EasyMock.createMock((String)"srs", SRS.class);
        BoundingBox bbox = new BoundingBox(10.0, 20.0, 30.0, 40.0);
        SecurityFilter filter = (SecurityFilter)EasyMock.createMock((String)"filter", SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter", filter, SecurityFilter.class);
        EasyMock.expect((Object)conv.getLayer()).andStubReturn((Object)layer);
        EasyMock.expect((Object)conv.getGridSubset()).andStubReturn((Object)subset);
        EasyMock.expect((Object)conv.getTileIndex()).andStubReturn((Object)new long[]{1L, 2L, 3L});
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)bbox);
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        filter.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{conv, layer, subset, srs, filter});
        secDispatcher.checkSecurity(conv);
        EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneFilterFail() throws Exception {
        SecurityDispatcher secDispatcher = new SecurityDispatcher();
        secDispatcher.setApplicationContext(this.extensions.getMockContext());
        ConveyorTile conv = (ConveyorTile)EasyMock.createMock((String)"conv", ConveyorTile.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)EasyMock.createMock((String)"subset", GridSubset.class);
        SRS srs = (SRS)EasyMock.createMock((String)"srs", SRS.class);
        BoundingBox bbox = new BoundingBox(10.0, 20.0, 30.0, 40.0);
        SecurityFilter filter = (SecurityFilter)EasyMock.createMock((String)"filter", SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter", filter, SecurityFilter.class);
        EasyMock.expect((Object)conv.getLayer()).andStubReturn((Object)layer);
        EasyMock.expect((Object)conv.getGridSubset()).andStubReturn((Object)subset);
        EasyMock.expect((Object)conv.getTileIndex()).andStubReturn((Object)new long[]{1L, 2L, 3L});
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)bbox);
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        filter.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().andThrow((Throwable)new SecurityException()).once();
        EasyMock.replay((Object[])new Object[]{conv, layer, subset, srs, filter});
        this.exception.expect(Matchers.instanceOf(SecurityException.class));
        try {
            secDispatcher.checkSecurity(conv);
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter});
    }

    @Test
    public void testTwoFilterPass() throws Exception {
        SecurityDispatcher secDispatcher = new SecurityDispatcher();
        secDispatcher.setApplicationContext(this.extensions.getMockContext());
        ConveyorTile conv = (ConveyorTile)EasyMock.createMock((String)"conv", ConveyorTile.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)EasyMock.createMock((String)"subset", GridSubset.class);
        SRS srs = (SRS)EasyMock.createMock((String)"srs", SRS.class);
        BoundingBox bbox = new BoundingBox(10.0, 20.0, 30.0, 40.0);
        SecurityFilter filter1 = (SecurityFilter)EasyMock.createMock((String)"filter1", SecurityFilter.class);
        SecurityFilter filter2 = (SecurityFilter)EasyMock.createMock((String)"filter2", SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter1", filter1, SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter2", filter2, SecurityFilter.class);
        EasyMock.expect((Object)conv.getLayer()).andStubReturn((Object)layer);
        EasyMock.expect((Object)conv.getGridSubset()).andStubReturn((Object)subset);
        EasyMock.expect((Object)conv.getTileIndex()).andStubReturn((Object)new long[]{1L, 2L, 3L});
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)bbox);
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        filter1.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().once();
        filter2.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{conv, layer, subset, srs, filter1, filter2});
        secDispatcher.checkSecurity(conv);
        EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter1, filter2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoFilterFail() throws Exception {
        SecurityDispatcher secDispatcher = new SecurityDispatcher();
        secDispatcher.setApplicationContext(this.extensions.getMockContext());
        ConveyorTile conv = (ConveyorTile)EasyMock.createMock((String)"conv", ConveyorTile.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)EasyMock.createMock((String)"subset", GridSubset.class);
        SRS srs = (SRS)EasyMock.createMock((String)"srs", SRS.class);
        BoundingBox bbox = new BoundingBox(10.0, 20.0, 30.0, 40.0);
        SecurityFilter filter1 = (SecurityFilter)EasyMock.createMock((String)"filter1", SecurityFilter.class);
        SecurityFilter filter2 = (SecurityFilter)EasyMock.createMock((String)"filter2", SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter1", filter1, SecurityFilter.class);
        this.extensions.addBean("testSecurityFilter2", filter2, SecurityFilter.class);
        EasyMock.expect((Object)conv.getLayer()).andStubReturn((Object)layer);
        EasyMock.expect((Object)conv.getGridSubset()).andStubReturn((Object)subset);
        EasyMock.expect((Object)conv.getTileIndex()).andStubReturn((Object)new long[]{1L, 2L, 3L});
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)bbox);
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        filter1.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().andThrow((Throwable)new SecurityException()).once();
        filter2.checkSecurity(layer, bbox, srs);
        EasyMock.expectLastCall().times(0, 1);
        EasyMock.replay((Object[])new Object[]{conv, layer, subset, srs, filter1, filter2});
        this.exception.expect(Matchers.instanceOf(SecurityException.class));
        try {
            secDispatcher.checkSecurity(conv);
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter1, filter2});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs, filter1, filter2});
    }

    @Test
    public void testNoFilterPass() throws Exception {
        SecurityDispatcher secDispatcher = new SecurityDispatcher();
        secDispatcher.setApplicationContext(this.extensions.getMockContext());
        ConveyorTile conv = (ConveyorTile)EasyMock.createMock((String)"conv", ConveyorTile.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subset = (GridSubset)EasyMock.createMock((String)"subset", GridSubset.class);
        SRS srs = (SRS)EasyMock.createMock((String)"srs", SRS.class);
        BoundingBox bbox = new BoundingBox(10.0, 20.0, 30.0, 40.0);
        EasyMock.expect((Object)conv.getLayer()).andStubReturn((Object)layer);
        EasyMock.expect((Object)conv.getGridSubset()).andStubReturn((Object)subset);
        EasyMock.expect((Object)conv.getTileIndex()).andStubReturn((Object)new long[]{1L, 2L, 3L});
        EasyMock.expect((Object)subset.boundsFromIndex(EasyMock.aryEq((long[])new long[]{1L, 2L, 3L}))).andStubReturn((Object)bbox);
        EasyMock.expect((Object)subset.getSRS()).andStubReturn((Object)srs);
        EasyMock.replay((Object[])new Object[]{conv, layer, subset, srs});
        secDispatcher.checkSecurity(conv);
        EasyMock.verify((Object[])new Object[]{conv, layer, subset, srs});
    }
}

