/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.geowebcache.grid.BoundingBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BoundingBoxTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testBBOX() throws Exception {
        BoundingBox bbox = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        assert (bbox.isSane());
        String bboxStr = bbox.toString();
        if (bboxStr.equalsIgnoreCase("-180.0,-90.0,180.0,90.0")) {
            Assert.assertTrue((boolean)true);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testBBOXScale() throws Exception {
        BoundingBox bbox = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        BoundingBox copy = new BoundingBox(bbox);
        bbox.scale(1.0);
        bbox.scale(0.5);
        bbox.scale(2.0);
        assert (bbox.isSane());
        assert (bbox.equals((Object)copy));
    }

    @Test
    public void testIntersection() throws Exception {
        BoundingBox bb1 = new BoundingBox(0.0, 0.0, 10.0, 10.0);
        BoundingBox bb2 = new BoundingBox(5.0, 5.0, 20.0, 20.0);
        BoundingBox intersection = BoundingBox.intersection((BoundingBox)bb1, (BoundingBox)bb2);
        Assert.assertNotNull((Object)intersection);
        Assert.assertEquals((double)5.0, (double)intersection.getWidth(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)intersection.getHeight(), (double)0.0);
        Assert.assertTrue((boolean)intersection.isSane());
        Assert.assertArrayEquals((double[])new double[]{5.0, 5.0, 10.0, 10.0}, (double[])intersection.getCoords(), (double)0.0);
    }

    @Test
    public void testIntersectionNonIntersecting() throws Exception {
        BoundingBox bb1 = new BoundingBox(0.0, 0.0, 10.0, 10.0);
        BoundingBox bb2 = new BoundingBox(11.0, 11.0, 20.0, 20.0);
        BoundingBox intersection = BoundingBox.intersection((BoundingBox)bb1, (BoundingBox)bb2);
        Assert.assertNotNull((Object)intersection);
        Assert.assertTrue((boolean)intersection.isNull());
        Assert.assertFalse((boolean)intersection.isSane());
    }
}

