/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.GWCConfigIntegrationTest;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GridSetBrokerTest
extends GWCConfigIntegrationTest {
    @Test
    public void testGridSetList() {
        Set names = this.gridSetBroker.getNames();
        int i = 0;
        for (GridSet grid : this.gridSetBroker.getGridSets()) {
            Assert.assertTrue((boolean)names.contains(grid.getName()));
            ++i;
        }
        Assert.assertEquals((long)i, (long)names.size());
    }

    @Test
    public void testGetDefaultGridsetOld() throws IOException {
        GridSet existingGridSet = this.gridSetBroker.get("EPSG:4326");
        Assert.assertThat((Object)existingGridSet, (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"EPSG:4326")));
    }

    @Test
    public void testGetDefaultGridSet() throws IOException {
        Optional existingGridSet = this.gridSetBroker.getGridSet("EPSG:4326");
        Assert.assertThat((Object)existingGridSet, TestUtils.isPresent(Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"EPSG:4326"))));
    }

    @Test
    public void testGetGridsetOld() throws IOException {
        GridSet existingGridSet = this.gridSetBroker.get("EPSG:2163");
        Assert.assertThat((Object)existingGridSet, (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"EPSG:2163")));
    }

    @Test
    public void testGetGridSet() throws IOException {
        Optional existingGridSet = this.gridSetBroker.getGridSet("EPSG:2163");
        Assert.assertThat((Object)existingGridSet, TestUtils.isPresent(Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"EPSG:2163"))));
    }

    @Test
    public void testGetNotPresentGridsetOld() throws IOException {
        GridSet existingGridSet = this.gridSetBroker.get("DOESNOTEXIST");
        Assert.assertThat((Object)existingGridSet, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetNotPresentGridSet() throws IOException {
        Optional existingGridSet = this.gridSetBroker.getGridSet("DOESNOTEXIST");
        Assert.assertThat((Object)existingGridSet, TestUtils.notPresent());
    }

    @Test
    public void testAddGridset() throws GeoWebCacheException, IOException {
        String gridsetName = "EPSG:3005";
        GridSet epsg3005 = GridSetFactory.createGridSet((String)gridsetName, (SRS)SRS.getSRS((String)gridsetName), (BoundingBox)new BoundingBox(35043.6538, 440006.8768, 1885895.3117, 1735643.8497), (boolean)false, null, (double[])new double[]{2.5E7, 1250000.0, 500000.0, 250000.0}, null, (double)2.8E-4, null, (int)256, (int)256, (boolean)false);
        this.gridSetBroker.addGridSet(epsg3005);
        Assert.assertTrue((boolean)this.gridSetBroker.getNames().contains(gridsetName));
        Assert.assertEquals((Object)this.gridSetBroker.get(gridsetName), (Object)epsg3005);
    }

    @Test
    public void testAddBadGridset() throws IOException {
        GridSet existingGridSet = this.gridSetBroker.get("EPSG:2163");
        try {
            this.gridSetBroker.addGridSet(existingGridSet);
            Assert.fail((String)"Expected exception adding existing gridset");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.gridSetBroker.addGridSet(null);
            Assert.fail((String)"Expected exception adding null gridset");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveGridsetOld() throws IOException {
        String gridsetToRemove = "EPSG:2163";
        this.gridSetBroker.remove(gridsetToRemove);
        Assert.assertFalse((boolean)this.gridSetBroker.getNames().contains(gridsetToRemove));
        Assert.assertNull((Object)this.gridSetBroker.get(gridsetToRemove));
    }

    @Test
    public void testRemoveGridset() throws IOException {
        String gridsetToRemove = "EPSG:2163";
        this.gridSetBroker.removeGridSet(gridsetToRemove);
        Assert.assertThat((Object)this.gridSetBroker.getGridSetNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)gridsetToRemove)));
        Assert.assertThat((Object)this.gridSetBroker.getGridSet(gridsetToRemove), TestUtils.notPresent());
    }
}

