/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Collections;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridAlignmentMismatchException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class GridSetTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
    GridSet gridSetTL = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)BoundingBox.WORLD4326, (boolean)true, (int)10, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
    GridSet gridSetBL = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)BoundingBox.WORLD4326, (boolean)false, (int)10, null, (double)2.8E-4, (int)256, (int)256, (boolean)false);
    GridSet gridSetTLswap = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)BoundingBox.WORLD4326, (boolean)true, (int)10, null, (double)2.8E-4, (int)256, (int)256, (boolean)true);
    GridSet gridSetBLswap = GridSetFactory.createGridSet((String)"test", (SRS)SRS.getEPSG4326(), (BoundingBox)BoundingBox.WORLD4326, (boolean)false, (int)10, null, (double)2.8E-4, (int)256, (int)256, (boolean)true);

    Matcher<BoundingBox> closeTo(BoundingBox expected, double error) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"minX", (Matcher)Matchers.closeTo((double)expected.getMinX(), (double)error)), (Matcher)Matchers.hasProperty((String)"minY", (Matcher)Matchers.closeTo((double)expected.getMinY(), (double)error)), (Matcher)Matchers.hasProperty((String)"maxX", (Matcher)Matchers.closeTo((double)expected.getMaxX(), (double)error)), (Matcher)Matchers.hasProperty((String)"maxY", (Matcher)Matchers.closeTo((double)expected.getMaxY(), (double)error)));
    }

    @Test
    public void testBoundsFromIndex() throws Exception {
        long[] index = new long[]{0L, 0L, 1L};
        BoundingBox bboxTL = this.gridSetTL.boundsFromIndex(index);
        BoundingBox bboxBL = this.gridSetBL.boundsFromIndex(index);
        BoundingBox bboxTLswap = this.gridSetTLswap.boundsFromIndex(index);
        BoundingBox bboxBLswap = this.gridSetBLswap.boundsFromIndex(index);
        BoundingBox solution = new BoundingBox(-180.0, -90.0, -90.0, 0.0);
        Assert.assertThat((Object)bboxTL, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxBL, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxTLswap, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxBLswap, this.closeTo(solution, 1.0E-8));
    }

    @Test
    public void testBounds() throws Exception {
        BoundingBox bboxTL = this.gridSetTL.getBounds();
        BoundingBox bboxBL = this.gridSetBL.getBounds();
        BoundingBox bboxTLswap = this.gridSetTLswap.getBounds();
        BoundingBox bboxBLswap = this.gridSetBLswap.getBounds();
        BoundingBox solution = new BoundingBox(-180.0, -90.0, 180.0, 90.0);
        Assert.assertThat((Object)bboxTL, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxBL, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxTLswap, this.closeTo(solution, 1.0E-8));
        Assert.assertThat((Object)bboxBLswap, this.closeTo(solution, 1.0E-8));
    }

    @Test
    public void testBoundsFromRectangle() throws Exception {
        long[] rect = new long[]{0L, 0L, 0L, 0L, 0L};
        BoundingBox bboxTL = this.gridSetTL.boundsFromRectangle(rect);
        BoundingBox bboxBL = this.gridSetBL.boundsFromRectangle(rect);
        BoundingBox bboxTLswap = this.gridSetTLswap.boundsFromRectangle(rect);
        BoundingBox bboxBLswap = this.gridSetBLswap.boundsFromRectangle(rect);
        BoundingBox solution = new BoundingBox(-180.0, -90.0, 0.0, 90.0);
        Assert.assertThat((Object)bboxTL, (Matcher)Matchers.equalTo((Object)solution));
        Assert.assertThat((Object)bboxBL, (Matcher)Matchers.equalTo((Object)solution));
        Assert.assertThat((Object)bboxTLswap, (Matcher)Matchers.equalTo((Object)solution));
        Assert.assertThat((Object)bboxBLswap, (Matcher)Matchers.equalTo((Object)solution));
        long[] rect2 = new long[]{2L, 1L, 2L, 1L, 1L};
        BoundingBox bboxTL2 = this.gridSetTL.boundsFromRectangle(rect2);
        BoundingBox bboxBL2 = this.gridSetBL.boundsFromRectangle(rect2);
        BoundingBox bboxTLswap2 = this.gridSetTLswap.boundsFromRectangle(rect2);
        BoundingBox bboxBLswap2 = this.gridSetBLswap.boundsFromRectangle(rect2);
        BoundingBox solution2 = new BoundingBox(0.0, 0.0, 90.0, 90.0);
        Assert.assertThat((Object)bboxTL2, (Matcher)Matchers.equalTo((Object)solution2));
        Assert.assertThat((Object)bboxBL2, (Matcher)Matchers.equalTo((Object)solution2));
        Assert.assertThat((Object)bboxTLswap2, (Matcher)Matchers.equalTo((Object)solution2));
        Assert.assertThat((Object)bboxBLswap2, (Matcher)Matchers.equalTo((Object)solution2));
    }

    @Test
    public void testClosestIndex() throws Exception {
        BoundingBox box = new BoundingBox(-180.0, -90.0, -90.0, 0.0);
        long[] idxTL = this.gridSetTL.closestIndex(box);
        long[] idxBL = this.gridSetBL.closestIndex(box);
        long[] solution = new long[]{0L, 0L, 1L};
        Assert.assertArrayEquals((long[])idxTL, (long[])solution);
        Assert.assertArrayEquals((long[])idxBL, (long[])solution);
    }

    @Test
    public void testClosestRectangle() throws Exception {
        BoundingBox box = new BoundingBox(-180.0, -90.0, 0.0, 0.0);
        long[] rectTL = this.gridSetTL.closestRectangle(box);
        long[] rectBL = this.gridSetBL.closestRectangle(box);
        long[] solution = new long[]{0L, 0L, 1L, 0L, 1L};
        Assert.assertArrayEquals((long[])rectTL, (long[])solution);
        Assert.assertArrayEquals((long[])rectBL, (long[])solution);
    }

    @Test
    public void testGetLeftTopCorner() throws Exception {
        double[] tlTL = this.gridSetTL.getOrderedTopLeftCorner(1);
        double[] tlBL = this.gridSetBL.getOrderedTopLeftCorner(1);
        Assert.assertThat((Object)tlBL[1], (Matcher)Matchers.closeTo((double)90.0, (double)0.01));
        Assert.assertThat((Object)tlTL[1], (Matcher)Matchers.closeTo((double)90.0, (double)0.01));
    }

    @Test
    public void testClosestIndexInvalidBounds1() throws Exception {
        BoundingBox box = new BoundingBox(0.0, -180.0, 180.0, 0.0);
        this.exception.expect(GridAlignmentMismatchException.class);
        this.gridSetTL.closestIndex(box);
    }

    @Test
    public void testClosestIndexInvalidBounds2() throws Exception {
        BoundingBox box = new BoundingBox(0.0, 0.0, 180.0, 180.0);
        this.exception.expect(GridAlignmentMismatchException.class);
        this.gridSetTL.closestIndex(box);
    }
}

