/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Collections;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.junit.Assert;
import org.junit.Test;

public class GridSubSetFactoryTest {
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));

    @Test
    public void testCoverageBounds() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)0);
        long[] ret = grid.getCoverage(0);
        long[] correct = new long[]{1L, 0L, 1L, 0L, 0L};
        Assert.assertArrayEquals((long[])correct, (long[])ret);
    }

    @Test
    public void testCoverageBounds2() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)1);
        long[] ret = grid.getCoverage(1);
        long[] correct = new long[]{2L, 1L, 3L, 1L, 1L};
        Assert.assertArrayEquals((long[])correct, (long[])ret);
    }

    @Test
    public void testGridNames() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        int zoomStart = 3;
        int zoomStop = 9;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)zoomStart, (Integer)zoomStop);
        String[] gridNames = grid.getGridNames();
        int nlevels = 1 + (grid.getZoomStop() - grid.getZoomStart());
        Assert.assertEquals((long)nlevels, (long)gridNames.length);
        for (String name : gridNames) {
            Assert.assertNotNull((Object)name);
        }
    }

    @Test
    public void testWMTSCoverage() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)1, (Integer)3);
        long[][] coverages = grid.getWMTSCoverages();
        Assert.assertEquals((long)3L, (long)coverages.length);
        long[] correct = new long[]{2L, 0L, 3L, 0L};
        Assert.assertArrayEquals((long[])correct, (long[])coverages[0]);
    }

    @Test
    public void testGridIndex() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        int zoomStart = 3;
        int zoomStop = 9;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)zoomStart, (Integer)zoomStop);
        String[] gridNames = grid.getGridNames();
        int i = 0;
        int z = zoomStart;
        while (i < gridNames.length) {
            Assert.assertEquals((long)z, (long)grid.getGridIndex(gridNames[i]));
            ++i;
            ++z;
        }
    }
}

