/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.media.jai.PlanarImage;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetaTileTest {
    GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void test1MetaTile() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        int metaHeight = 1;
        int metaWidth = 1;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        long[] gridPos = new long[]{0L, 0L, 0L};
        WMSMetaTile mt = new WMSMetaTile(null, grid, (MimeType)ImageMime.png, null, gridPos, metaWidth, metaHeight, Collections.singletonMap("test", "test1"));
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, 0L, 0L, 0L}, (long[])mt.getMetaTileGridBounds());
    }

    @Test
    public void test2MetaTile() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        int metaHeight = 3;
        int metaWidth = 3;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        long[] gridPos = new long[]{127L, 63L, 6L};
        WMSMetaTile mt = new WMSMetaTile(null, grid, (MimeType)ImageMime.png, null, gridPos, metaWidth, metaHeight, Collections.singletonMap("test", "test1"));
        long[] solution = new long[]{126L, 63L, 127L, 63L, 6L};
        Assert.assertArrayEquals((long[])mt.getMetaTileGridBounds(), (long[])solution);
    }

    @Test
    public void test3MetaTile() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 2.003750834E7, 2.003750834E7);
        int metaHeight = 1;
        int metaWidth = 1;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        long[] gridPos = new long[]{0L, 0L, 0L};
        WMSMetaTile mt = new WMSMetaTile(null, grid, (MimeType)ImageMime.png, null, gridPos, metaWidth, metaHeight, Collections.singletonMap("test", "test1"));
        long[] solution = new long[]{0L, 0L, 0L, 0L, 0L};
        Assert.assertArrayEquals((long[])mt.getMetaTileGridBounds(), (long[])solution);
    }

    @Test
    public void test4MetaTile() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 2.003750834E7, 2.003750834E7);
        int metaHeight = 3;
        int metaWidth = 3;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg3857(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        long[] gridPos = new long[]{70L, 70L, 6L};
        WMSMetaTile mt = new WMSMetaTile(null, grid, (MimeType)ImageMime.png, null, gridPos, metaWidth, metaHeight, Collections.singletonMap("test", "test1"));
        long[] solution = new long[]{69L, 69L, 63L, 63L, 6L};
        Assert.assertArrayEquals((long[])mt.getMetaTileGridBounds(), (long[])solution);
    }

    @Test
    public void test5MetaTileGutter() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        WMSLayer layer = this.createWMSLayer(bbox);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        layer.gutter = 50;
        long[] gridPos = new long[]{127L, 63L, 6L};
        WMSMetaTile mt = new WMSMetaTile(layer, grid, (MimeType)ImageMime.png, null, gridPos, layer.getMetaTilingFactors()[0], layer.getMetaTilingFactors()[1], Collections.singletonMap("test", "test1"));
        Map wmsParams = mt.getWMSParams();
        Assert.assertEquals((long)layer.gutter.intValue(), (long)mt.getGutter()[0]);
        Assert.assertEquals((long)layer.gutter.intValue(), (long)mt.getGutter()[1]);
        Assert.assertEquals((long)0L, (long)mt.getGutter()[2]);
        Assert.assertEquals((long)0L, (long)mt.getGutter()[3]);
        int height = Integer.parseInt((String)wmsParams.get("HEIGHT"));
        Assert.assertEquals((long)height, (long)306L);
        long[] midGridPos = new long[]{83L, 45L, 6L};
        mt = new WMSMetaTile(layer, grid, (MimeType)ImageMime.png, null, midGridPos, layer.getMetaTilingFactors()[0], layer.getMetaTilingFactors()[1], Collections.singletonMap("test", "test1"));
        wmsParams = mt.getWMSParams();
        Assert.assertEquals((long)mt.getGutter()[0], (long)layer.gutter.intValue());
        Assert.assertEquals((long)mt.getGutter()[1], (long)layer.gutter.intValue());
        Assert.assertEquals((long)mt.getGutter()[2], (long)layer.gutter.intValue());
        Assert.assertEquals((long)mt.getGutter()[3], (long)layer.gutter.intValue());
        height = Integer.parseInt((String)wmsParams.get("HEIGHT"));
        Assert.assertEquals((long)height, (long)868L);
        String[] coordStrs = ((String)wmsParams.get("BBOX")).split(",");
        Assert.assertTrue((Math.abs(Double.parseDouble(coordStrs[0]) - 47.26318359375) < 0.001 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(Double.parseDouble(coordStrs[3]) - 45.54931640625) < 0.001 ? 1 : 0) != 0);
    }

    @Test
    public void test6MetaTileNoGutterWithVector() throws Exception {
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        WMSLayer layer = this.createWMSLayer(bbox);
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)bbox, (Integer)0, (Integer)30);
        layer.gutter = 50;
        long[] gridPos = new long[]{127L, 63L, 6L};
        WMSMetaTile mt = new WMSMetaTile(layer, grid, (MimeType)ApplicationMime.topojson, null, gridPos, layer.getMetaTilingFactors()[0], layer.getMetaTilingFactors()[1], Collections.singletonMap("test", "test1"));
        Map wmsParams = mt.getWMSParams();
        Assert.assertEquals((long)0L, (long)mt.getGutter()[0]);
        Assert.assertEquals((long)0L, (long)mt.getGutter()[1]);
        Assert.assertEquals((long)0L, (long)mt.getGutter()[2]);
        Assert.assertEquals((long)0L, (long)mt.getGutter()[3]);
        int height = Integer.parseInt((String)wmsParams.get("HEIGHT"));
        Assert.assertEquals((long)height, (long)256L);
    }

    private WMSLayer createWMSLayer(BoundingBox layerBounds) {
        String[] urls = new String[]{"http://localhost:38080/wms"};
        LinkedList<String> formatList = new LinkedList<String>();
        formatList.add("image/png");
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>();
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326());
        grids.put(grid.getName(), grid);
        int[] metaWidthHeight = new int[]{3, 3};
        WMSLayer layer = new WMSLayer("test:layer", urls, "aStyle", "test:layer", formatList, grids, null, metaWidthHeight, "vendorparam=true", false, null);
        layer.initialize(this.gridSetBroker);
        return layer;
    }

    @Test
    public void testCreateTileFromMetaTileBufferImage() throws Exception {
        Color[][] colors = new Color[2][2];
        BufferedImage image = this.createBufferImageMetaTile(2, 2, 256, 512, colors);
        this.commonCreateTileFromMetaTileTest(colors, image);
    }

    @Test
    public void testCreateTileFromMetaTilePlanarImage() throws Exception {
        Color[][] colors = new Color[2][2];
        BufferedImage image = this.createBufferImageMetaTile(2, 2, 256, 512, colors);
        this.commonCreateTileFromMetaTileTest(colors, (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)image));
    }

    private void commonCreateTileFromMetaTileTest(Color[][] colors, RenderedImage metaTileImage) throws Exception {
        BoundingBox boundingBox = new BoundingBox(0.0, 0.0, 180.0, 90.0);
        int metaHeight = 2;
        int metaWidth = 2;
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.getWorldEpsg4326(), (BoundingBox)boundingBox, (Integer)0, (Integer)21);
        long[] gridPos = new long[]{0L, 0L, 0L};
        MetaTile metaTile = new MetaTile(grid, (MimeType)ImageMime.png, null, gridPos, metaWidth, metaHeight, null);
        metaTile.setImage(metaTileImage);
        int width = metaTile.getMetaTileWidth();
        int height = metaTile.getMetaTileHeight();
        this.checkImageBorderSameColor(metaTile.createTile(0, 0, width, height), colors[0][0]);
        this.checkImageBorderSameColor(metaTile.createTile(width, 0, width, height), colors[0][1]);
        this.checkImageBorderSameColor(metaTile.createTile(0, height, width, height), colors[1][0]);
        this.checkImageBorderSameColor(metaTile.createTile(width, height, width, height), colors[1][1]);
    }

    private void checkImageBorderSameColor(RenderedImage image, Color color) throws Exception {
        int i;
        if (image instanceof PlanarImage) {
            image = ((PlanarImage)image).getAsBufferedImage();
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] borderA = (int[])image.getData().getDataElements(0, 0, width, 1, null);
        int[] borderB = (int[])image.getData().getDataElements(0, height - 1, width, 1, null);
        int[] borderC = (int[])image.getData().getDataElements(0, 0, 1, height, null);
        int[] borderD = (int[])image.getData().getDataElements(width - 1, 0, 1, height, null);
        int colorInt = color.getRGB();
        for (i = 0; i < width; ++i) {
            if (borderA[i] == colorInt && borderB[i] == colorInt) continue;
            Assert.fail((String)"Not the expected color.");
        }
        for (i = 0; i < height; ++i) {
            if (borderC[i] == colorInt && borderD[i] == colorInt) continue;
            Assert.fail((String)"Not the expected color.");
        }
    }

    private BufferedImage createBufferImageMetaTile(int rows, int columns, int height, int width, Color[][] colors) {
        Random random = new Random();
        BufferedImage image = new BufferedImage(columns * width, rows * height, 2);
        Graphics2D graphics = image.createGraphics();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                Color color;
                colors[i][j] = color = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
                graphics.setColor(color);
                int x = j * width;
                int y = i * height;
                graphics.fill(new Rectangle2D.Float(x, y, width, height));
            }
        }
        graphics.dispose();
        return image;
    }
}

