/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class TileLayerTest {
    @Test
    public void testGetModifiableParameters() throws Exception {
        LinkedList<ParameterFilter> filters = new LinkedList<ParameterFilter>();
        StringParameterFilter filter = new StringParameterFilter();
        filter.setKey("FILTER1");
        filter.setValues(Arrays.asList("foo", "bar"));
        filters.add((ParameterFilter)filter);
        filter = new StringParameterFilter();
        filter.setKey("FILTER2");
        filter.setValues(Arrays.asList("quux", "quam"));
        filters.add((ParameterFilter)filter);
        filter = new StringParameterFilter();
        filter.setKey("FILTER3");
        filter.setValues(Arrays.asList("quux", "quam"));
        filters.add((ParameterFilter)filter);
        HashMap<String, String[]> rawParams = new HashMap<String, String[]>();
        rawParams.put("FILTER1", new String[]{"bar"});
        rawParams.put("FILTER3", new String[]{"quux"});
        rawParams.put("FILTER4", new String[]{"quux"});
        TileLayer layer = this.getLayerWithFilters(filters);
        Map result = layer.getModifiableParameters(rawParams, "UTF-8");
        Assert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalToIgnoringCase((String)"FILTER1"), (Matcher)Matchers.equalTo((Object)"bar")));
        Assert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalToIgnoringCase((String)"FILTER2"), (Matcher)Matchers.equalTo((Object)"")));
        Assert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalToIgnoringCase((String)"FILTER3"), (Matcher)Matchers.equalTo((Object)"quux")));
        Assert.assertThat((Object)result, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.equalToIgnoringCase((String)"FILTER4"), (Matcher)Matchers.notNullValue())));
    }

    protected abstract TileLayer getLayerWithFilters(Collection<ParameterFilter> var1) throws Exception;
}

