/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import java.util.ArrayList;
import java.util.Collection;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class ApplicationMimeTest {

    public static class OneOffApplicationMimeTest {
        @Test
        public void testMapboxLegacyFormat() throws MimeException {
            MimeType mime = MimeType.createFromFormat((String)"application/x-protobuf;type=mapbox-vector");
            Assert.assertNotNull((Object)mime);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ParametricApplicationMimeTest {
        private MimeType mimeType;

        @Parameterized.Parameters(name="{index}: {0}")
        public static Collection<Object[]> data() {
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            for (MimeType mt : ApplicationMime.ALL) {
                data.add(new Object[]{mt.getFormat(), mt});
            }
            return data;
        }

        public ParametricApplicationMimeTest(String format, MimeType mt) {
            this.mimeType = mt;
        }

        @Test
        public void testMimeType() throws MimeException {
            MimeType result = MimeType.createFromFormat((String)this.mimeType.getFormat());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)this.mimeType, (Object)result);
            result = MimeType.createFromExtension((String)this.mimeType.getFileExtension());
            Assert.assertEquals((Object)this.mimeType, (Object)result);
        }
    }
}

