/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageMimeTest {
    private BufferedImage indexed;
    private BufferedImage gray;
    private BufferedImage rgb;
    private BufferedImage rgba;
    private BufferedImage rgba_opaque;
    private BufferedImage rgba_partial;

    @Before
    public void prepareImages() {
        this.indexed = new BufferedImage(10, 10, 13);
        this.gray = new BufferedImage(10, 10, 10);
        this.rgb = new BufferedImage(10, 10, 5);
        this.rgba = new BufferedImage(10, 10, 6);
        this.rgba_opaque = new BufferedImage(10, 10, 6);
        Graphics2D graphics = this.rgba_opaque.createGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 10, 10);
        graphics.dispose();
        this.rgba_partial = new BufferedImage(10, 10, 6);
        graphics = this.rgba_partial.createGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 10, 5);
        graphics.dispose();
    }

    @Test
    public void testJpegPng() throws MimeException {
        Assert.assertNotNull((Object)MimeType.createFromFormat((String)"image/vnd.jpeg-png"));
        Assert.assertNotNull((Object)MimeType.createFromExtension((String)"jpeg-png"));
    }

    @Test
    public void testJpegPngImageWriter() {
        this.assertExpectedWriter(this.indexed, ImageMime.png);
        this.assertExpectedWriter(this.gray, ImageMime.jpeg);
        this.assertExpectedWriter(this.gray, ImageMime.jpeg);
        this.assertExpectedWriter(this.rgba, ImageMime.png);
        this.assertExpectedWriter(this.rgba_opaque, ImageMime.jpeg);
        this.assertExpectedWriter(this.rgba_partial, ImageMime.png);
    }

    @Test
    public void testJpegPngMime() throws IOException {
        Resource pngImage = this.getAsResource(this.indexed, ImageMime.png);
        Assert.assertEquals((Object)"image/png", (Object)ImageMime.jpegPng.getMimeType(pngImage));
        Resource jpegImage = this.getAsResource(this.rgb, ImageMime.jpeg);
        Assert.assertEquals((Object)"image/jpeg", (Object)ImageMime.jpegPng.getMimeType(jpegImage));
    }

    private Resource getAsResource(BufferedImage image, ImageMime mime) throws IOException {
        ImageWriter writer = mime.getImageWriter((RenderedImage)image);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(image);
        ios.flush();
        return new ByteArrayResource(os.toByteArray());
    }

    private void assertExpectedWriter(BufferedImage bi, ImageMime expectedMime) {
        ImageWriter jpegPngWriter = ImageMime.jpegPng.getImageWriter((RenderedImage)bi);
        ImageWriter expectedWriter = expectedMime.getImageWriter((RenderedImage)bi);
        Assert.assertEquals(expectedWriter.getClass(), jpegPngWriter.getClass());
    }

    @Test
    public void testIsCompatileFailsOnXMLMime() {
        ImageMime pngMimeType = ImageMime.jpeg;
        Assert.assertFalse((String)"PNG mime type should not be compatible with XML error.", (boolean)pngMimeType.isCompatible("application/vnd.ogc.se_xml"));
    }

    @Test
    public void test4BitPNG() throws IOException, URISyntaxException {
        URL url = this.getClass().getResource("/images/4bit.png");
        BufferedImage tile = ImageIO.read(new File(url.toURI()));
        ImageWriter writer = ImageMime.png8.getImageWriter((RenderedImage)tile);
        Assert.assertNotEquals((String)"Writer for this image should not be the native version.", (Object)writer.getClass().getName(), (Object)"com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter");
    }
}

