/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.junit.Assert;
import org.junit.Test;

public class XMLMimeTest {
    @Test
    public void testOGC() {
        MimeType result = null;
        try {
            result = MimeType.createFromFormat((String)"application/vnd.ogc.se_xml");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.ogcxml, (Object)result);
    }

    @Test
    public void testKML() {
        MimeType result = null;
        try {
            result = MimeType.createFromFormat((String)"application/vnd.google-earth.kml+xml");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.kml, (Object)result);
        try {
            result = MimeType.createFromExtension((String)"kml");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.kml, (Object)result);
    }

    @Test
    public void testKMZ() {
        MimeType result = null;
        try {
            result = MimeType.createFromFormat((String)"application/vnd.google-earth.kmz");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.kmz, (Object)result);
        try {
            result = MimeType.createFromExtension((String)"kmz");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.kmz, (Object)result);
    }

    @Test
    public void testGML() {
        MimeType result = null;
        try {
            result = MimeType.createFromFormat((String)"application/vnd.ogc.gml");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.gml, (Object)result);
        try {
            result = MimeType.createFromExtension((String)"gml");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.gml, (Object)result);
    }

    @Test
    public void testGML3() {
        MimeType result = null;
        try {
            result = MimeType.createFromFormat((String)"application/vnd.ogc.gml/3.1.1");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.gml3, (Object)result);
        try {
            result = MimeType.createFromExtension((String)"gml3");
        }
        catch (MimeException e) {
            Assert.fail((String)"Format not found");
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)XMLMime.gml3, (Object)result);
    }

    @Test
    public void testUnknownExtension() throws MimeException {
        MimeType result = MimeType.createFromExtension((String)"xxx");
        Assert.assertNull((Object)result);
    }

    @Test(expected=MimeException.class)
    public void testUnknownFormat() throws MimeException {
        MimeType.createFromFormat((String)"xxx/xxx");
    }
}

