/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.easymock.EasyMock;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.seed.TruncateBboxRequest;
import org.geowebcache.storage.StorageBroker;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.integration.EasyMock2Adapter;
import org.junit.Assert;
import org.junit.Test;

public class TruncateBboxRequestTest {
    protected SeedRequest seedRequest(String layerName, String gridSet, String format, int minZ, int maxZ, BoundingBox bounds, Map<String, String> parameters) {
        EasyMock2Adapter.adapt((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"layerName", (Matcher)Matchers.equalTo((Object)layerName)), Matchers.hasProperty((String)"gridSetId", (Matcher)Matchers.equalTo((Object)gridSet)), Matchers.hasProperty((String)"mimeFormat", (Matcher)Matchers.equalTo((Object)format)), Matchers.hasProperty((String)"zoomStart", (Matcher)Matchers.equalTo((Object)minZ)), Matchers.hasProperty((String)"zoomStop", (Matcher)Matchers.equalTo((Object)maxZ)), Matchers.hasProperty((String)"parameters", (Matcher)Matchers.equalTo(parameters)), Matchers.hasProperty((String)"filterUpdate", (Matcher)Matchers.any(Boolean.class)), Matchers.hasProperty((String)"threadCount", (Matcher)Matchers.any(Integer.class)), Matchers.hasProperty((String)"bounds", (Matcher)Matchers.equalTo((Object)bounds)), Matchers.hasProperty((String)"type", (Matcher)Matchers.any(GWCTask.TYPE.class))}));
        return null;
    }

    @Test
    public void testDoTruncate() throws Exception {
        String layerName = "testLayer";
        BoundingBox bbox = new BoundingBox(0.0, 1.0, 10.0, 11.0);
        String gridSetName = "testGridset";
        TruncateBboxRequest request = new TruncateBboxRequest(layerName, bbox, gridSetName);
        StorageBroker broker = (StorageBroker)EasyMock.createMock((String)"broker", StorageBroker.class);
        TileBreeder breeder = (TileBreeder)EasyMock.createMock((String)"breeder", TileBreeder.class);
        TileLayer layer = (TileLayer)EasyMock.createMock((String)"layer", TileLayer.class);
        GridSubset subSet = (GridSubset)EasyMock.createMock((String)"subSet", GridSubset.class);
        GWCTask pngStyle1 = (GWCTask)EasyMock.createMock((String)"pngStyle1", GWCTask.class);
        GWCTask pngStyle2 = (GWCTask)EasyMock.createMock((String)"pngStyle2", GWCTask.class);
        GWCTask jpegStyle1 = (GWCTask)EasyMock.createMock((String)"jpegStyle1", GWCTask.class);
        GWCTask jpegStyle2 = (GWCTask)EasyMock.createMock((String)"jpegStyle2", GWCTask.class);
        HashSet<Map<String, String>> allParams = new HashSet<Map<String, String>>();
        allParams.add(Collections.singletonMap("STYLES", "style1"));
        allParams.add(Collections.singletonMap("STYLES", "style2"));
        long[][] coverages = new long[][]{{0L, 0L, 0L, 0L, 0L}, {0L, 0L, 1L, 1L, 1L}, {0L, 0L, 4L, 4L, 2L}};
        int[] metaFactors = new int[]{1, 1};
        EasyMock.expect((Object)broker.getCachedParameters(layerName)).andStubReturn(Collections.unmodifiableSet(allParams));
        EasyMock.expect((Object)breeder.findTileLayer(layerName)).andStubReturn((Object)layer);
        EasyMock.expect((Object)layer.getGridSubset(gridSetName)).andStubReturn((Object)subSet);
        EasyMock.expect((Object)layer.getMimeTypes()).andStubReturn(Arrays.asList(ImageMime.png, ImageMime.jpeg));
        EasyMock.expect((Object)subSet.getMinCachedZoom()).andStubReturn((Object)0);
        EasyMock.expect((Object)subSet.getMaxCachedZoom()).andStubReturn((Object)2);
        EasyMock.expect((Object)subSet.getZoomStart()).andStubReturn((Object)0);
        EasyMock.expect((Object)subSet.getZoomStop()).andStubReturn((Object)2);
        EasyMock.expect((Object)subSet.getCoverageIntersections(bbox)).andStubReturn((Object)coverages);
        EasyMock.expect((Object)layer.getMetaTilingFactors()).andStubReturn((Object)metaFactors);
        EasyMock.expect((Object)subSet.expandToMetaFactors((long[][])coverages, metaFactors)).andStubReturn((Object)coverages);
        EasyMock.expect((Object)layer.getName()).andStubReturn((Object)layerName);
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/png", 0, 2, bbox, Collections.singletonMap("STYLES", "style1")));
        EasyMock.expectLastCall().once();
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/png", 0, 2, bbox, Collections.singletonMap("STYLES", "style2")));
        EasyMock.expectLastCall().once();
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/png", 0, 2, bbox, null));
        EasyMock.expectLastCall().once();
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/jpeg", 0, 2, bbox, Collections.singletonMap("STYLES", "style1")));
        EasyMock.expectLastCall().once();
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/jpeg", 0, 2, bbox, Collections.singletonMap("STYLES", "style2")));
        EasyMock.expectLastCall().once();
        breeder.seed((String)EasyMock.eq((Object)layerName), this.seedRequest(layerName, gridSetName, "image/jpeg", 0, 2, bbox, null));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{broker, breeder, layer, subSet});
        EasyMock.replay((Object[])new Object[]{pngStyle1, pngStyle2, jpegStyle1, jpegStyle2});
        Assert.assertThat((Object)request.doTruncate(broker, breeder), (Matcher)Matchers.is((Object)true));
        EasyMock.verify((Object[])new Object[]{broker, breeder, layer, subSet});
    }
}

