/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.util.FileMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractBlobStoreTest<TestClass extends BlobStore> {
    protected TestClass store;
    protected boolean events = true;

    @Before
    public abstract void createTestUnit() throws Exception;

    @After
    public void destroyTestUnit() throws Exception {
        if (Objects.nonNull(this.store)) {
            this.store.destroy();
        }
    }

    @Test
    public void testEmpty() throws Exception {
        TileObject fromCache = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        Assert.assertThat((Object)this.store.get(fromCache), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testStoreTile() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        long size = toCache.getBlobSize();
        TileObject fromCache = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size))));
        Assert.assertThat((Object)fromCache, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testStoreTilesInMultipleLayers() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer1", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer2", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject fromCache1 = TileObject.createQueryTileObject((String)"testLayer1", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer2", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer2", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer1"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size1));
            listener.tileStored((String)EasyMock.eq((Object)"testLayer2"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size2));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache2_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testDeleteTile() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject remove = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        TileObject fromCache = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        Capture sizeCapture = EasyMock.newCapture();
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache);
        EasyMock.verify((Object[])new Object[]{listener});
        long storedSize = 0L;
        if (this.events) {
            storedSize = (Long)sizeCapture.getValue();
        }
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.tileDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((long)storedSize));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.delete(remove);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void testUpdateTile() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size2 = toCache2.getBlobSize();
        TileObject fromCache = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", null);
        Capture sizeCapture = EasyMock.newCapture();
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        EasyMock.verify((Object[])new Object[]{listener});
        long storedSize = 0L;
        if (this.events) {
            storedSize = (Long)sizeCapture.getValue();
        }
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.tileUpdated((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size2), EasyMock.eq((long)storedSize));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testGridsets() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject remove = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        TileObject fromCache1_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        TileObject fromCache2_3 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        Capture sizeCapture1 = EasyMock.newCapture();
        Capture sizeCapture2 = EasyMock.newCapture();
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet1"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture1));
            EasyMock.expectLastCall();
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet2"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture2));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        long storedSize1 = 0L;
        if (this.events) {
            storedSize1 = (Long)sizeCapture1.getValue();
        }
        Assert.assertThat((Object)this.store.get(fromCache1_1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.tileDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet1"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((long)storedSize1));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.delete(remove);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
        Assert.assertThat((Object)this.store.get(fromCache2_3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testDeleteGridset() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        long size1 = toCache1.getBlobSize();
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet1"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq(null), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size1));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        EasyMock.verify((Object[])new Object[]{listener});
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.gridSubsetDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet1"));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.deleteByGridsetId("testLayer", "testGridSet1"), (Matcher)Matchers.is((Object)true));
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void testDeleteGridsetDoesntDeleteOthers() throws Exception {
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject fromCache1_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet1", (String)"image/png", null);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        TileObject fromCache2_3 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet2", (String)"image/png", null);
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        this.store.put(toCache2);
        Assert.assertThat((Object)this.store.get(fromCache1_1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
        this.store.deleteByGridsetId("testLayer", "testGridSet1");
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
        Assert.assertThat((Object)this.store.get(fromCache2_3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testParameters() throws Exception {
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject remove = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache1_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        TileObject fromCache2_3 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        Capture sizeCapture1 = EasyMock.newCapture();
        Capture sizeCapture2 = EasyMock.newCapture();
        Capture pidCapture1 = EasyMock.newCapture();
        Capture pidCapture2 = EasyMock.newCapture();
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.capture((Capture)pidCapture1), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture1));
            EasyMock.expectLastCall();
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.capture((Capture)pidCapture2), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.captureLong((Capture)sizeCapture2));
            EasyMock.expectLastCall();
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        long storedSize1 = 0L;
        if (this.events) {
            storedSize1 = (Long)sizeCapture1.getValue();
            Assert.assertThat((Object)((String)pidCapture1.getValue()), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)((String)pidCapture2.getValue()), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)((String)pidCapture2.getValue()), (Matcher)Matchers.not((Object)((String)pidCapture1.getValue())));
        }
        Assert.assertThat((Object)this.store.get(fromCache1_1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.tileDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)((String)pidCapture1.getValue())), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.eq((long)storedSize1));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.delete(remove);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
        Assert.assertThat((Object)this.store.get(fromCache2_3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testMetadata() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "testKey", "testValue");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testMetadataWithEqualsInKey() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test=Key"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "test=Key", "testValue");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test=Key"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testMetadataWithEqualsInValue() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "testKey", "test=Value");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.equalTo((Object)"test=Value"));
    }

    @Test
    public void testMetadataWithAmpInKey() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test&Key"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "test&Key", "testValue");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test&Key"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testMetadataWithAmpInValue() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "testKey", "test&Value");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.equalTo((Object)"test&Value"));
    }

    @Test
    public void testMetadataWithPercentInKey() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test%Key"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "test%Key", "testValue");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "test%Key"), (Matcher)Matchers.equalTo((Object)"testValue"));
    }

    @Test
    public void testMetadataWithPercentInValue() throws Exception {
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.nullValue());
        this.store.putLayerMetadata("testLayer", "testKey", "test%Value");
        Assert.assertThat((Object)this.store.getLayerMetadata("testLayer", "testKey"), (Matcher)Matchers.equalTo((Object)"test%Value"));
    }

    @Test
    @Ignore
    public void testParameterList() throws Exception {
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        Assert.assertThat((Object)this.store.getParameters("testLayer"), (Matcher)Matchers.empty());
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.getParameters("testLayer"), (Matcher)Matchers.containsInAnyOrder((Object[])new Map[]{params1}));
        this.store.put(toCache2);
        Assert.assertThat((Object)this.store.getParameters("testLayer"), (Matcher)Matchers.containsInAnyOrder((Object[])new Map[]{params1, params2}));
    }

    @Test
    public void testParameterIDList() throws Exception {
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        String params1Id = ParametersUtils.getId(params1);
        String params2Id = ParametersUtils.getId(params2);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        Assert.assertThat((Object)this.store.getParameterIds("testLayer"), (Matcher)Matchers.empty());
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.getParameterIds("testLayer"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{params1Id}));
        this.store.put(toCache2);
        Assert.assertThat((Object)this.store.getParameterIds("testLayer"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{params1Id, params2Id}));
    }

    @Test
    public void testEmptyParameterListIsNotNull() throws Exception {
        Assert.assertThat((Object)this.store.getParameters("testLayer"), (Matcher)Matchers.empty());
    }

    @Test
    public void testDeleteByParametersId() throws Exception {
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        String paramID1 = ParametersUtils.getId(params1);
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        String paramID2 = ParametersUtils.getId(params2);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject fromCache1_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID1), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size1));
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID2), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size2));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.parametersDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)paramID1));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.deleteByParametersId("testLayer", paramID1);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void testDeleteByParametersIdDoesNotDeleteOthers() throws Exception {
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        String paramID1 = ParametersUtils.getId(params1);
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        long size2 = toCache2.getBlobSize();
        TileObject fromCache2_3 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        this.store.put(toCache1);
        this.store.put(toCache2);
        this.store.deleteByParametersId("testLayer", paramID1);
        Assert.assertThat((Object)this.store.get(fromCache2_3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_3, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    @Ignore
    public void testPurgeOrphans() throws Exception {
        TileLayer layer = (TileLayer)EasyMock.createNiceMock((String)"layer", TileLayer.class);
        EasyMock.expect((Object)layer.getName()).andStubReturn((Object)"testLayer");
        StringParameterFilter testFilter = new StringParameterFilter();
        testFilter.setDefaultValue("DEFAULT");
        testFilter.setKey("testKey");
        testFilter.setValues(Arrays.asList("testValue2"));
        EasyMock.expect((Object)layer.getParameterFilters()).andStubReturn(Arrays.asList(testFilter));
        EasyMock.replay((Object[])new Object[]{layer});
        Map<String, String> params1 = Collections.singletonMap("testKey", "testValue1");
        String paramID1 = ParametersUtils.getId(params1);
        Map<String, String> params2 = Collections.singletonMap("testKey", "testValue2");
        String paramID2 = ParametersUtils.getId(params2);
        TileObject toCache1 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1, (Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)));
        TileObject toCache2 = TileObject.createCompleteTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2, (Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)));
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        long size1 = toCache1.getBlobSize();
        long size2 = toCache2.getBlobSize();
        TileObject fromCache1_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_1 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        TileObject fromCache1_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params1);
        TileObject fromCache2_2 = TileObject.createQueryTileObject((String)"testLayer", (long[])new long[]{0L, 0L, 0L}, (String)"testGridSet", (String)"image/png", params2);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID1), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size1));
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID2), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.geq((long)size2));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.put(toCache1);
        Assert.assertThat((Object)this.store.get(fromCache2_1), (Matcher)Matchers.is((Object)false));
        this.store.put(toCache2);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size1))));
        Assert.assertThat((Object)fromCache1_1, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("1,2,4,5,6 test".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat((Object)this.store.get(fromCache2_2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)((int)size2))));
        Assert.assertThat((Object)fromCache2_2, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource("7,8,9,10 test".getBytes(StandardCharsets.UTF_8)))));
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.parametersDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)paramID1));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.purgeOrphans(layer);
        EasyMock.verify((Object[])new Object[]{listener});
        Assert.assertThat((Object)this.store.get(fromCache1_2), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)fromCache1_2, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
    }

    protected void cacheTile(String layerName, long x, long y, int z, String gridSetId, String format, Map<String, String> parameters, String content) throws StorageException {
        TileObject to = TileObject.createCompleteTileObject((String)layerName, (long[])new long[]{x, y, z}, (String)gridSetId, (String)format, parameters, (Resource)new ByteArrayResource(content.getBytes(StandardCharsets.UTF_8)));
        this.store.put(to);
    }

    protected void assertTile(String layerName, long x, long y, int z, String gridSetId, String format, Map<String, String> parameters, String content) throws StorageException {
        TileObject to = TileObject.createQueryTileObject((String)layerName, (long[])new long[]{x, y, z}, (String)gridSetId, (String)format, parameters);
        Assert.assertThat((Object)this.store.get(to), (Matcher)Matchers.describedAs((String)"get a tile", (Matcher)Matchers.is((Object)true), (Object[])new Object[0]));
        Assert.assertThat((Object)to, (Matcher)Matchers.hasProperty((String)"blob", FileMatchers.resource((Resource)new ByteArrayResource(content.getBytes(StandardCharsets.UTF_8)))));
    }

    protected void assertNoTile(String layerName, long x, long y, int z, String gridSetId, String format, Map<String, String> parameters) throws StorageException {
        TileObject to = TileObject.createQueryTileObject((String)layerName, (long[])new long[]{x, y, z}, (String)gridSetId, (String)format, parameters);
        Assert.assertThat((Object)this.store.get(to), (Matcher)Matchers.describedAs((String)"don't get a tile", (Matcher)Matchers.is((Object)false), (Object[])new Object[0]));
        Assert.assertThat((Object)to, (Matcher)Matchers.hasProperty((String)"blob", (Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)to, (Matcher)Matchers.hasProperty((String)"blobSize", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    @Ignore
    public void testPurgeOrphansWithDefault() throws Exception {
        TileLayer layer = (TileLayer)EasyMock.createNiceMock((String)"layer", TileLayer.class);
        String layerName = "testLayer";
        String paramKey = "testKey";
        EasyMock.expect((Object)layer.getName()).andStubReturn((Object)"testLayer");
        StringParameterFilter testFilter = new StringParameterFilter();
        testFilter.setDefaultValue("DEFAULT");
        testFilter.setKey("testKey");
        testFilter.setValues(Arrays.asList("keep1", "keep2", "keep3"));
        EasyMock.expect((Object)layer.getParameterFilters()).andStubReturn(Arrays.asList(testFilter));
        EasyMock.replay((Object[])new Object[]{layer});
        Map<String, String> params1 = Collections.singletonMap("testKey", "purge1");
        String paramID1 = ParametersUtils.getId(params1);
        Map<String, String> params2 = Collections.singletonMap("testKey", "keep1");
        String paramID2 = ParametersUtils.getId(params2);
        String gridset = "testGridSet";
        String format = "image/png";
        BlobStoreListener listener = (BlobStoreListener)EasyMock.createNiceMock(BlobStoreListener.class);
        this.store.addListener(listener);
        if (this.events) {
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID1), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.anyLong());
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.eq((Object)paramID2), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.anyLong());
            listener.tileStored((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)"testGridSet"), (String)EasyMock.eq((Object)"image/png"), (String)EasyMock.isNull(), EasyMock.eq((long)0L), EasyMock.eq((long)0L), EasyMock.eq((int)0), EasyMock.anyLong());
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.cacheTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params1, "purge");
        this.cacheTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params2, "keep param");
        this.cacheTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", null, "keep default");
        EasyMock.verify((Object[])new Object[]{listener});
        this.assertTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params1, "purge");
        this.assertTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params2, "keep param");
        this.assertTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", null, "keep default");
        EasyMock.reset((Object[])new Object[]{listener});
        if (this.events) {
            listener.parametersDeleted((String)EasyMock.eq((Object)"testLayer"), (String)EasyMock.eq((Object)paramID1));
        }
        EasyMock.replay((Object[])new Object[]{listener});
        this.store.purgeOrphans(layer);
        EasyMock.verify((Object[])new Object[]{listener});
        this.assertNoTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params1);
        this.assertTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", params2, "keep param");
        this.assertTile("testLayer", 0L, 0L, 0, "testGridSet", "image/png", null, "keep default");
    }

    @Test
    public void testDeleteRangeSingleLevel() throws StorageException {
        TileLayer layer = (TileLayer)EasyMock.createNiceMock((String)"layer", TileLayer.class);
        String layerName = "testLayer";
        EasyMock.expect((Object)layer.getName()).andStubReturn((Object)"testLayer");
        GridSet gridSet = new DefaultGridsets(true, false).worldEpsg4326();
        String format = ImageMime.png.getFormat();
        String content = "sample";
        String gridsetId = gridSet.getName();
        this.setupFullCoverage("testLayer", gridSet, format, content, gridsetId, 0, 2);
        TileRange range = new TileRange("testLayer", gridsetId, 2, 2, (long[][])new long[][]{{0L, 0L, 2L, 2L, 2L}}, (MimeType)ImageMime.png, null);
        this.store.delete(range);
        this.assertTileRangeEmpty("testLayer", gridSet, format, range);
        this.assertTile("testLayer", 0L, 0L, 0, gridsetId, format, null, content);
        this.assertTile("testLayer", 1L, 0L, 0, gridsetId, format, null, content);
        this.assertTile("testLayer", 0L, 0L, 1, gridsetId, format, null, content);
    }

    @Test
    public void testDeleteRangeMultiLevel() throws StorageException {
        TileLayer layer = (TileLayer)EasyMock.createNiceMock((String)"layer", TileLayer.class);
        String layerName = "testLayer";
        EasyMock.expect((Object)layer.getName()).andStubReturn((Object)"testLayer");
        GridSet gridSet = new DefaultGridsets(true, false).worldEpsg4326();
        String format = ImageMime.png.getFormat();
        String content = "sample";
        String gridsetId = gridSet.getName();
        this.setupFullCoverage("testLayer", gridSet, format, content, gridsetId, 0, 2);
        TileRange range = new TileRange("testLayer", gridsetId, 1, 2, (long[][])new long[][]{{0L, 0L, 2L, 2L, 1L}, {0L, 0L, 2L, 2L, 2L}}, (MimeType)ImageMime.png, null);
        this.store.delete(range);
        this.assertTileRangeEmpty("testLayer", gridSet, format, range);
        this.assertTile("testLayer", 0L, 0L, 0, gridsetId, format, null, content);
        this.assertTile("testLayer", 1L, 0L, 0, gridsetId, format, null, content);
    }

    public void setupFullCoverage(String layerName, GridSet gridSet, String format, String content, String gridsetId, int minZ, int maxZ) throws StorageException {
        for (int z = minZ; z <= maxZ; ++z) {
            Grid grid = gridSet.getGrid(z);
            int x = 0;
            while ((long)x < grid.getNumTilesWide()) {
                int y = 0;
                while ((long)y < grid.getNumTilesHigh()) {
                    this.cacheTile(layerName, x, y, z, gridsetId, format, null, content);
                    ++y;
                }
                ++x;
            }
        }
    }

    public void assertTileRangeEmpty(String layerName, GridSet gridSet, String format, TileRange range) throws StorageException {
        for (int z = range.getZoomStart(); z <= range.getZoomStop(); ++z) {
            long[] bounds = range.rangeBounds(z);
            for (long x = bounds[0]; x <= bounds[2]; ++x) {
                for (long y = bounds[1]; y < bounds[2]; ++y) {
                    this.assertNoTile(layerName, x, y, z, gridSet.getName(), format, null);
                }
            }
        }
    }
}

