/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.SuitabilityCheckRule;
import org.geowebcache.storage.TileObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CompositeBlobStoreTest {
    private static final String DEFAULT_GRIDSET = "EPSG:4326";
    private static final String DEFAULT_FORMAT = "png";
    private static final String DEFAULT_LAYER = "topp:states";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException ex = ExpectedException.none();
    @Rule
    public SuitabilityCheckRule suitability = SuitabilityCheckRule.system();
    TileLayerDispatcher layers;
    BlobStoreAggregator bsa;
    DefaultStorageFinder defaultStorageFinder;
    XMLConfiguration configuration;
    List<BlobStoreInfo> configs;
    private CompositeBlobStore store;
    private TileLayer defaultLayer;

    @Before
    public void setup() throws Exception {
        this.layers = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.bsa = (BlobStoreAggregator)Mockito.mock(BlobStoreAggregator.class);
        this.defaultStorageFinder = (DefaultStorageFinder)Mockito.mock(DefaultStorageFinder.class);
        this.configuration = (XMLConfiguration)Mockito.mock(XMLConfiguration.class);
        this.configs = new LinkedList<BlobStoreInfo>();
        Mockito.when((Object)this.bsa.getBlobStores()).thenReturn(this.configs);
        Mockito.when((Object)this.defaultStorageFinder.getDefaultPath()).thenReturn((Object)this.tmpFolder.getRoot().getAbsolutePath());
        this.defaultLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)this.layers.getTileLayer((String)ArgumentMatchers.eq((Object)DEFAULT_LAYER))).thenReturn((Object)this.defaultLayer);
        Mockito.when((Object)this.layers.getTileLayer((String)ArgumentMatchers.argThat(new NotEq<String>(DEFAULT_LAYER)))).thenThrow(new Throwable[]{new GeoWebCacheException("layer not found")});
    }

    private CompositeBlobStore create() throws StorageException, ConfigurationException {
        return new CompositeBlobStore(this.layers, this.defaultStorageFinder, (ServerConfiguration)this.configuration, this.bsa);
    }

    @Test
    public void noStoresDefinedCreatesLegacyDefaultStore() throws Exception {
        this.store = this.create();
        Assert.assertEquals((long)1L, (long)this.store.blobStores.size());
        CompositeBlobStore.LiveStore liveStore = (CompositeBlobStore.LiveStore)this.store.blobStores.get("_DEFAULT_STORE_");
        Assert.assertNotNull((Object)liveStore);
        Assert.assertTrue((boolean)(liveStore.config instanceof FileBlobStoreInfo));
        FileBlobStoreInfo config = (FileBlobStoreInfo)liveStore.config;
        Assert.assertTrue((boolean)config.isEnabled());
        Assert.assertTrue((boolean)config.isDefault());
        Assert.assertEquals((Object)this.tmpFolder.getRoot().getAbsolutePath(), (Object)config.getBaseDirectory());
    }

    @Test
    public void noExplicitDefaultCreatesLegacyDefaultStore() throws Exception {
        boolean isDefault = false;
        this.configs.add((BlobStoreInfo)this.config("store1", false, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.configs.add((BlobStoreInfo)this.config("store2", false, true, this.tmpFolder.newFolder().getAbsolutePath(), 2048));
        this.store = this.create();
        Map stores = this.store.blobStores;
        Assert.assertEquals((long)3L, (long)stores.size());
        CompositeBlobStore.LiveStore defaultStore = (CompositeBlobStore.LiveStore)stores.get("_DEFAULT_STORE_");
        Assert.assertNotNull((Object)defaultStore);
        Assert.assertNotEquals((Object)this.configs.get(0), (Object)defaultStore.config);
        Assert.assertNotEquals((Object)this.configs.get(1), (Object)defaultStore.config);
    }

    @Test
    public void duplicateDefaultStoreFails() throws Exception {
        boolean isDefault = true;
        this.configs.add((BlobStoreInfo)this.config("store1", true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.configs.add((BlobStoreInfo)this.config("store2", true, true, this.tmpFolder.newFolder().getAbsolutePath(), 2048));
        this.ex.expect(ConfigurationException.class);
        this.ex.expectMessage("Duplicate default blob store");
        this.store = this.create();
    }

    @Test
    public void nullStoreIdFails() throws Exception {
        String id = null;
        this.configs.add((BlobStoreInfo)this.config(id, true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.ex.expect(ConfigurationException.class);
        this.ex.expectMessage("No id provided for blob store");
        this.store = this.create();
    }

    @Test
    public void duplicateStoreIdFails() throws Exception {
        String id = "ImDuplicate";
        this.configs.add((BlobStoreInfo)this.config(id, true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.configs.add((BlobStoreInfo)this.config(id, true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.ex.expect(ConfigurationException.class);
        this.ex.expectMessage("Duplicate blob store id");
        this.store = this.create();
    }

    @Test
    public void defaultAndDisaledFails() throws Exception {
        boolean isDefault = true;
        boolean enabled = false;
        this.configs.add((BlobStoreInfo)this.config("storeId", isDefault, enabled, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.ex.expect(ConfigurationException.class);
        this.ex.expectMessage("The default blob store can't be disabled");
        this.store = this.create();
    }

    @Test
    public void disabledStoreHasNoLiveInstance() throws Exception {
        boolean enabled = false;
        this.configs.add((BlobStoreInfo)this.config("storeId", false, enabled, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.store = this.create();
        Assert.assertNotNull(this.store.blobStores.get("storeId"));
        Assert.assertNull((Object)((CompositeBlobStore.LiveStore)this.store.blobStores.get((Object)"storeId")).liveInstance);
    }

    @Test
    public void reservedDefaultIdInvalidInConfig() throws Exception {
        String id = "_DEFAULT_STORE_";
        this.configs.add((BlobStoreInfo)this.config(id, true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.ex.expect(ConfigurationException.class);
        this.ex.expectMessage(id + " is a reserved identifier");
        this.store = this.create();
    }

    @Test
    public void configuredDefaultRespectedAndNoLegacyDefaultCreated() throws Exception {
        this.configs.add((BlobStoreInfo)this.config("some-other", false, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        FileBlobStoreInfo defaultStore = this.config("default-store", true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024);
        this.configs.add((BlobStoreInfo)defaultStore);
        this.store = this.create();
        Assert.assertSame((Object)defaultStore, (Object)((CompositeBlobStore.LiveStore)this.store.blobStores.get((Object)"_DEFAULT_STORE_")).config);
        Assert.assertSame((Object)defaultStore, (Object)((CompositeBlobStore.LiveStore)this.store.blobStores.get((Object)"default-store")).config);
        Assert.assertEquals((long)3L, (long)this.store.blobStores.size());
    }

    @Test
    public void getTileInvalidBlobStore() throws Exception {
        this.configs.add((BlobStoreInfo)this.config("default", true, true, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.store = this.create();
        Mockito.when((Object)this.defaultLayer.getBlobStoreId()).thenReturn((Object)"nonExistentStore");
        this.ex.expect(StorageException.class);
        this.ex.expectMessage("No BlobStore with id 'nonExistentStore' found");
        this.store.get(this.queryTile(0L, 0L, 0));
    }

    @Test
    public void getTileDefaultsToDefaultBlobStore() throws Exception {
        this.store = this.create();
        CompositeBlobStore.LiveStore liveStore = (CompositeBlobStore.LiveStore)this.store.blobStores.get("_DEFAULT_STORE_");
        liveStore.liveInstance = (BlobStore)Mockito.spy((Object)liveStore.liveInstance);
        Mockito.when((Object)this.defaultLayer.getBlobStoreId()).thenReturn(null);
        TileObject tile = this.queryTile(0L, 0L, 0);
        this.store.get(tile);
        ((BlobStore)Mockito.verify((Object)liveStore.liveInstance)).get(tile);
    }

    @Test
    public void getTileInvalidLayer() throws Exception {
        this.store = this.create();
        CompositeBlobStore.LiveStore liveStore = (CompositeBlobStore.LiveStore)this.store.blobStores.get("_DEFAULT_STORE_");
        liveStore.liveInstance = (BlobStore)Mockito.spy((Object)liveStore.liveInstance);
        Mockito.when((Object)this.defaultLayer.getBlobStoreId()).thenReturn(null);
        TileObject tile = this.queryTile("someLayer", DEFAULT_GRIDSET, DEFAULT_FORMAT, 0L, 0L, 0);
        this.ex.expect(StorageException.class);
        this.ex.expectMessage("layer not found");
        this.store.get(tile);
    }

    @Test
    public void getTileDisabledStore() throws Exception {
        boolean isEnabled = false;
        this.configs.add((BlobStoreInfo)this.config("store1", false, isEnabled, this.tmpFolder.newFolder().getAbsolutePath(), 1024));
        this.store = this.create();
        Mockito.when((Object)this.defaultLayer.getBlobStoreId()).thenReturn((Object)"store1");
        TileObject tile = this.queryTile(0L, 0L, 0);
        this.ex.expect(StorageException.class);
        this.ex.expectMessage("Attempted to use a blob store that's disabled");
        this.store.get(tile);
    }

    @Test
    public void testSuitabilityOnStartup() throws Exception {
        Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EXISTING));
        BlobStoreInfo info = (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class);
        Mockito.when((Object)info.getName()).thenReturn((Object)"testStore");
        Mockito.when((Object)info.isEnabled()).thenReturn((Object)true);
        BlobStore subStore = (BlobStore)Mockito.mock(BlobStore.class);
        Mockito.when((Object)info.createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any())).thenAnswer(invocation -> {
            Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.NONE));
            return subStore;
        });
        this.configs.add(info);
        this.store = this.create();
        ((BlobStoreInfo)Mockito.verify((Object)info)).createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any());
        Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EXISTING));
    }

    @Test
    public void testSuitabilityOnAdd() throws Exception {
        BlobStoreInfo info = (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class);
        Mockito.when((Object)info.getName()).thenReturn((Object)"testStore");
        Mockito.when((Object)info.isEnabled()).thenReturn((Object)true);
        BlobStore subStore = (BlobStore)Mockito.mock(BlobStore.class);
        Mockito.when((Object)info.createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any())).thenAnswer(invocation -> {
            Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EXISTING));
            return subStore;
        });
        this.store = this.create();
        this.store.handleAddBlobStore(info);
        ((BlobStoreInfo)Mockito.verify((Object)info)).createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any());
    }

    @Test
    public void testNonDefaultSuitabilityOnStartup() throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EMPTY);
        Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EMPTY));
        BlobStoreInfo info = (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class);
        Mockito.when((Object)info.getName()).thenReturn((Object)"testStore");
        Mockito.when((Object)info.isEnabled()).thenReturn((Object)true);
        BlobStore subStore = (BlobStore)Mockito.mock(BlobStore.class);
        Mockito.when((Object)info.createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any())).thenAnswer(invocation -> {
            Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.NONE));
            return subStore;
        });
        this.configs.add(info);
        this.store = this.create();
        ((BlobStoreInfo)Mockito.verify((Object)info)).createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any());
        Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EMPTY));
    }

    @Test
    public void testNonDefaultSuitabilityOnAdd() throws Exception {
        this.suitability.setValue(CompositeBlobStore.StoreSuitabilityCheck.EMPTY);
        BlobStoreInfo info = (BlobStoreInfo)Mockito.mock(BlobStoreInfo.class);
        Mockito.when((Object)info.getName()).thenReturn((Object)"testStore");
        Mockito.when((Object)info.isEnabled()).thenReturn((Object)true);
        BlobStore subStore = (BlobStore)Mockito.mock(BlobStore.class);
        Mockito.when((Object)info.createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any())).thenAnswer(invocation -> {
            Assert.assertThat((Object)CompositeBlobStore.getStoreSuitabilityCheck(), (Matcher)Matchers.equalTo((Object)CompositeBlobStore.StoreSuitabilityCheck.EMPTY));
            return subStore;
        });
        this.store = this.create();
        this.store.handleAddBlobStore(info);
        ((BlobStoreInfo)Mockito.verify((Object)info)).createInstance((TileLayerDispatcher)Mockito.any(), (LockProvider)Mockito.any());
    }

    private FileBlobStoreInfo config(String id, boolean isDefault, boolean isEnabled, String baseDirectory, int fileSystemBlockSize) {
        FileBlobStoreInfo c = new FileBlobStoreInfo(id);
        c.setDefault(isDefault);
        c.setEnabled(isEnabled);
        c.setBaseDirectory(baseDirectory);
        c.setFileSystemBlockSize(fileSystemBlockSize);
        return c;
    }

    private TileObject queryTile(long x, long y, int z) {
        return this.queryTile(DEFAULT_LAYER, DEFAULT_GRIDSET, DEFAULT_FORMAT, x, y, z);
    }

    private TileObject queryTile(String layer, String gridset, String extension, long x, long y, int z) {
        return this.queryTile(layer, gridset, extension, x, y, z, null);
    }

    private TileObject queryTile(String layer, String gridset, String extension, long x, long y, int z, Map<String, String> parameters) {
        String format;
        try {
            format = MimeType.createFromExtension((String)extension).getFormat();
        }
        catch (MimeException e) {
            throw new RuntimeException(e);
        }
        TileObject tile = TileObject.createQueryTileObject((String)layer, (long[])new long[]{x, y, z}, (String)gridset, (String)format, parameters);
        return tile;
    }

    private static class NotEq<T>
    implements ArgumentMatcher<T> {
        private T val;

        public NotEq(T val) {
            this.val = val;
        }

        public boolean matches(Object argument) {
            return !this.val.equals(argument);
        }
    }
}

