/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.LinkedList;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.AbstractBlobStoreTest;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class CompositeBlobStoreWithFilesComformanceTest
extends AbstractBlobStoreTest<CompositeBlobStore> {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private TileLayerDispatcher tld;
    private BlobStoreAggregator bsa;
    private DefaultStorageFinder defaultStorageFinder;
    private XMLConfiguration configuration;
    private TileLayer defaultLayer;
    private TileLayer defaultLayer1;
    private TileLayer defaultLayer2;
    private LinkedList<BlobStoreInfo> configs;
    private String DEFAULT_LAYER = "testLayer";
    private String DEFAULT_LAYER1 = "testLayer1";
    private String DEFAULT_LAYER2 = "testLayer2";

    @Override
    public void createTestUnit() throws Exception {
        this.tld = (TileLayerDispatcher)EasyMock.createNiceMock((String)"tld", TileLayerDispatcher.class);
        this.bsa = (BlobStoreAggregator)EasyMock.createNiceMock((String)"bsa", BlobStoreAggregator.class);
        this.defaultStorageFinder = (DefaultStorageFinder)EasyMock.createNiceMock((String)"defaultStorageFinder", DefaultStorageFinder.class);
        this.configuration = (XMLConfiguration)EasyMock.createNiceMock((String)"configuration", XMLConfiguration.class);
        this.configs = new LinkedList();
        EasyMock.expect((Object)this.bsa.getBlobStores()).andStubReturn(this.configs);
        EasyMock.expect((Object)this.defaultStorageFinder.getDefaultPath()).andStubReturn((Object)this.temp.getRoot().getAbsolutePath());
        this.defaultLayer = (TileLayer)EasyMock.createNiceMock((String)"defaultLayer", TileLayer.class);
        this.defaultLayer1 = (TileLayer)EasyMock.createNiceMock((String)"defaultLayer1", TileLayer.class);
        this.defaultLayer2 = (TileLayer)EasyMock.createNiceMock((String)"defaultLayer2", TileLayer.class);
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.eq((Object)this.DEFAULT_LAYER))).andStubReturn((Object)this.defaultLayer);
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.eq((Object)this.DEFAULT_LAYER1))).andStubReturn((Object)this.defaultLayer1);
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.eq((Object)this.DEFAULT_LAYER2))).andStubReturn((Object)this.defaultLayer2);
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.not((Object)((String)EasyMock.or((Object)((String)EasyMock.eq((Object)this.DEFAULT_LAYER)), (Object)((String)EasyMock.or((Object)((String)EasyMock.eq((Object)this.DEFAULT_LAYER1)), (Object)((String)EasyMock.eq((Object)this.DEFAULT_LAYER2))))))))).andStubThrow((Throwable)new GeoWebCacheException("layer not found"));
        EasyMock.replay((Object[])new Object[]{this.tld, this.bsa, this.defaultStorageFinder, this.configuration, this.defaultLayer, this.defaultLayer1, this.defaultLayer2});
        this.store = new CompositeBlobStore(this.tld, this.defaultStorageFinder, (ServerConfiguration)this.configuration, this.bsa);
    }

    @Before
    public void setEvents() throws Exception {
        this.events = true;
    }
}

