/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import com.google.common.base.Ticker;
import java.io.InputStream;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.TransientCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransientCacheTest {
    TransientCache transCache;
    TestTicker ticker;
    public static final long EXPIRE_TIME = 2000L;
    public static final int MAX_TILES = 5;
    public static final int MAX_SPACE_KiB = 5;

    @Before
    public void setUp() throws Exception {
        this.transCache = new TransientCache(5, 5, 2000L);
        this.ticker = new TestTicker(System.nanoTime());
        this.transCache.setTicker((Ticker)this.ticker);
    }

    @Test
    public void testHit() throws Exception {
        ByteArrayResource r = new ByteArrayResource(new byte[]{1, 2, 3});
        this.transCache.put("foo", (Resource)r);
        this.ticker.advanceMilli(1999L);
        Resource result = this.transCache.get("foo");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)r.getLastModified(), (Matcher)CoreMatchers.equalTo((Object)r.getLastModified()));
        try (InputStream is = result.getInputStream();){
            Assert.assertThat((Object)is.read(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertThat((Object)is.read(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((Object)is.read(), (Matcher)CoreMatchers.equalTo((Object)3));
            Assert.assertThat((Object)is.read(), (Matcher)CoreMatchers.equalTo((Object)-1));
        }
    }

    @Test
    public void testRemoveOnHit() throws Exception {
        ByteArrayResource r = new ByteArrayResource(new byte[]{1, 2, 3});
        this.transCache.put("foo", (Resource)r);
        this.ticker.advanceMilli(1999L);
        this.transCache.get("foo");
        Resource result = this.transCache.get("foo");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRemoveOnExpire() throws Exception {
        ByteArrayResource r = new ByteArrayResource(new byte[]{1, 2, 3});
        this.transCache.put("foo", (Resource)r);
        this.ticker.advanceMilli(2001L);
        Resource result = this.transCache.get("foo");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRemoveWhenMaxTiles() throws Exception {
        for (byte i = 0; i < 5; i = (byte)(i + 1)) {
            ByteArrayResource r = new ByteArrayResource(new byte[]{(byte)(i + 1), (byte)(i + 2), (byte)(i + 3)});
            this.transCache.put("foo" + i, (Resource)r);
            Assert.assertThat((Object)this.transCache.size(), (Matcher)CoreMatchers.is((Object)(i + 1)));
        }
        Assert.assertThat((Object)this.transCache.storageSize(), (Matcher)CoreMatchers.is((Object)15L));
        ByteArrayResource r = new ByteArrayResource(new byte[]{6, 7});
        this.transCache.put("foo5", (Resource)r);
        Assert.assertThat((Object)this.transCache.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)this.transCache.storageSize(), (Matcher)CoreMatchers.is((Object)14L));
        this.ticker.advanceMilli(1L);
        Resource result1 = this.transCache.get("foo0");
        Assert.assertThat((Object)result1, (Matcher)CoreMatchers.nullValue());
        Resource result2 = this.transCache.get("foo1");
        Assert.assertThat((Object)result2, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testRemoveWhenMaxSpace() throws Exception {
        for (long i = 0L; i < 5L; ++i) {
            ByteArrayResource r = new ByteArrayResource(new byte[i == 0L ? 1023 : 1024]);
            this.transCache.put("foo" + i, (Resource)r);
            Assert.assertThat((Object)this.transCache.storageSize(), (Matcher)CoreMatchers.is((Object)((i + 1L) * 1024L - 1L)));
            this.ticker.advanceMilli(1L);
        }
        Assert.assertThat((Object)this.transCache.storageSize(), (Matcher)CoreMatchers.is((Object)5119L));
        Assert.assertThat((Object)this.transCache.size(), (Matcher)CoreMatchers.is((Object)5));
        ByteArrayResource r = new ByteArrayResource(new byte[2]);
        this.transCache.put("foo5", (Resource)r);
        Assert.assertThat((Object)this.transCache.storageSize(), (Matcher)CoreMatchers.is((Object)4098L));
        Assert.assertThat((Object)this.transCache.size(), (Matcher)CoreMatchers.is((Object)5));
        this.ticker.advanceMilli(1L);
        Resource result1 = this.transCache.get("foo0");
        Assert.assertThat((Object)result1, (Matcher)CoreMatchers.nullValue());
        Resource result2 = this.transCache.get("foo1");
        Assert.assertThat((Object)result2, (Matcher)CoreMatchers.notNullValue());
    }

    private static class TestTicker
    extends Ticker {
        long time;

        public TestTicker(long startAt) {
            this.time = startAt;
        }

        public long read() {
            return this.time;
        }

        public void advanceMilli(long millis) {
            this.advanceNano(millis * 1000L);
        }

        public void advanceNano(long nanos) {
            this.time += nanos;
        }
    }
}

