/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.geowebcache.io.Resource;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public class FileMatchers {
    private FileMatchers() {
        throw new IllegalStateException();
    }

    public static Matcher<File> exists() {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                if (item instanceof File) {
                    return ((File)item).exists();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("file that exists");
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof File) {
                    description.appendValue(item);
                    description.appendText(" does not exist");
                } else {
                    description.appendValue(item);
                    description.appendText(" was not a File object");
                }
            }
        };
    }

    public static Matcher<File> file() {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                if (item instanceof File) {
                    return ((File)item).isFile();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("file that is a file (Not a directory)");
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof File) {
                    if (((File)item).exists()) {
                        description.appendValue(item);
                        description.appendText(" is a directory");
                    } else {
                        description.appendValue(item);
                        description.appendText(" does not exist");
                    }
                } else {
                    description.appendValue(item);
                    description.appendText(" was not a File object");
                }
            }
        };
    }

    public static Matcher<File> directory() {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                if (item instanceof File) {
                    return ((File)item).isDirectory();
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("file that is a directory");
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof File) {
                    if (((File)item).exists()) {
                        description.appendValue(item);
                        description.appendText(" is not a directory");
                    } else {
                        description.appendValue(item);
                        description.appendText(" does not exist");
                    }
                } else {
                    description.appendValue(item);
                    description.appendText(" was not a File object");
                }
            }
        };
    }

    public static Matcher<File> directoryContaining(final Matcher<Iterable<File>> filesMatcher) {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                if (item instanceof File) {
                    return ((File)item).isDirectory() && filesMatcher.matches(Arrays.asList(((File)item).listFiles()));
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("directory that contains ");
                description.appendDescriptionOf((SelfDescribing)filesMatcher);
            }

            public void describeMismatch(Object item, Description description) {
                if (!(item instanceof File)) {
                    description.appendValue(item);
                    description.appendText(" was not a File object");
                } else if (!((File)item).exists()) {
                    description.appendValue(item);
                    description.appendText(" does not exist");
                } else if (!((File)item).isDirectory()) {
                    description.appendValue(item);
                    description.appendText(" is not a directory");
                } else {
                    description.appendValue(item);
                    description.appendText(" had files ");
                    filesMatcher.describeMismatch((Object)((File)item).listFiles(), description);
                }
            }
        };
    }

    public static Matcher<File> directoryEmpty() {
        return FileMatchers.directoryContaining((Matcher<Iterable<File>>)Matchers.emptyIterableOf(File.class));
    }

    public static Matcher<File> lastModified(final Matcher<Long> timeMatcher) {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                if (item instanceof File) {
                    return timeMatcher.matches((Object)((File)item).lastModified());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("file last modified ");
                description.appendDescriptionOf((SelfDescribing)timeMatcher);
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof File) {
                    if (((File)item).exists()) {
                        description.appendValue(item);
                        description.appendText(" had modification time ");
                        timeMatcher.describeMismatch((Object)((File)item).lastModified(), description);
                    } else {
                        description.appendValue(item);
                        description.appendText(" does not exist");
                    }
                } else {
                    description.appendValue(item);
                    description.appendText(" was not a File object");
                }
            }
        };
    }

    public static Matcher<File> named(String name) {
        return Matchers.both((Matcher)Matchers.instanceOf(File.class)).and(Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)name)));
    }

    public static Matcher<Long> whileRunning(Callable<Void> stuffToDo) throws Exception {
        long start = System.currentTimeMillis();
        stuffToDo.call();
        long end = System.currentTimeMillis();
        return Matchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(start))).and(Matchers.lessThan((Comparable)Long.valueOf(end)));
    }

    public static Matcher<Resource> resource(final Resource expected) {
        return new BaseMatcher<Resource>(){

            /*
             * Enabled aggressive exception aggregation
             */
            public boolean matches(Object item) {
                if (item instanceof Resource) {
                    try (InputStream itemStream = ((Resource)item).getInputStream();){
                        boolean bl;
                        block15: {
                            InputStream expectedStream = expected.getInputStream();
                            try {
                                bl = IOUtils.contentEquals((InputStream)itemStream, (InputStream)expectedStream);
                                if (expectedStream == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (expectedStream != null) {
                                    try {
                                        expectedStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            expectedStream.close();
                        }
                        return bl;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Resource with content equal to that given");
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof Resource) {
                    description.appendText("did not match given Resource");
                } else {
                    description.appendText("was not a Resource");
                }
            }
        };
    }
}

