/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.junit.Assert;

public class MockLockProvider
extends MemoryLockProvider {
    public AtomicLong acquires = new AtomicLong();
    public AtomicLong releases = new AtomicLong();
    public Map<String, String> keys = new ConcurrentHashMap<String, String>();

    public LockProvider.Lock getLock(String lockKey) {
        super.getLock(lockKey);
        this.acquires.incrementAndGet();
        Assert.assertFalse((boolean)this.keys.containsKey(lockKey));
        this.keys.put(lockKey, lockKey);
        return () -> {
            this.releases.incrementAndGet();
            Assert.assertTrue((boolean)this.keys.containsKey(lockKey));
            this.keys.remove(lockKey);
        };
    }

    public void verify() {
        Assert.assertEquals((long)this.acquires.get(), (long)this.releases.get());
        Assert.assertEquals((long)0L, (long)this.keys.size());
    }

    public void clear() {
        this.acquires.set(0L);
        this.releases.set(0L);
    }
}

