/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.layer.EmptyTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ResponseUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class ResponseUtilsTest {
    @Mock
    SecurityDispatcher sd;
    @Mock
    ConveyorTile tile;
    @Mock
    TileLayer tileLayer;
    @Mock
    TileLayerDispatcher tld;
    @Mock
    DefaultStorageFinder storage;
    @Mock
    RuntimeStats stats;
    private MockHttpServletResponse response;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.tld.getTileLayer("layer")).thenReturn((Object)this.tileLayer);
        this.response = new MockHttpServletResponse();
        this.tile.servletResp = this.response;
    }

    @Test
    public void writeEmptyTileNoContent() throws GeoWebCacheException, RequestFilterException, IOException {
        Mockito.when((Object)this.tileLayer.getTile(this.tile)).thenThrow(new Throwable[]{new EmptyTileException((MimeType)ApplicationMime.mapboxVector)});
        ResponseUtils.writeTile((SecurityDispatcher)this.sd, (Conveyor)this.tile, (String)"layer", (TileLayerDispatcher)this.tld, (DefaultStorageFinder)this.storage, (RuntimeStats)this.stats);
        Assert.assertEquals((long)204L, (long)this.response.getStatus());
        Assert.assertEquals((Object)ApplicationMime.mapboxVector.getMimeType(), (Object)this.response.getContentType());
        Assert.assertEquals((Object)"No tile data available for this location", (Object)this.response.getHeader("geowebcache-message"));
    }

    @Test
    public void writeEmptyTileJSON() throws GeoWebCacheException, RequestFilterException, IOException {
        String emptyJSON = "{}";
        Mockito.when((Object)this.tileLayer.getTile(this.tile)).thenThrow(new Throwable[]{new EmptyTileException((MimeType)ApplicationMime.json, new ByteArrayResource(emptyJSON.getBytes(StandardCharsets.UTF_8)))});
        ResponseUtils.writeTile((SecurityDispatcher)this.sd, (Conveyor)this.tile, (String)"layer", (TileLayerDispatcher)this.tld, (DefaultStorageFinder)this.storage, (RuntimeStats)this.stats);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
        Assert.assertEquals((Object)ApplicationMime.json.getMimeType(), (Object)this.response.getContentType());
        Assert.assertEquals((Object)emptyJSON, (Object)this.response.getContentAsString());
        Assert.assertEquals((Object)"No tile data available for this location", (Object)this.response.getHeader("geowebcache-message"));
    }

    @Test
    public void writeOutOfBoundsTile() throws GeoWebCacheException, RequestFilterException, IOException {
        Mockito.when((Object)this.tileLayer.getTile(this.tile)).thenThrow(new Throwable[]{new OutsideCoverageException(new long[]{0L, 0L, 10L}, 0L, 5L)});
        ResponseUtils.writeTile((SecurityDispatcher)this.sd, (Conveyor)this.tile, (String)"layer", (TileLayerDispatcher)this.tld, (DefaultStorageFinder)this.storage, (RuntimeStats)this.stats);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)this.response.getContentType());
        Assert.assertEquals((Object)"Zoom level was 10, but value has to be in [0,5]", (Object)this.response.getHeader("geowebcache-message"));
    }
}

