/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;

public class TestUtils {
    private TestUtils() {
    }

    public static byte[] createFakeSourceImage(WMSLayer layer, String gridsetId) throws IOException {
        int tileWidth = layer.getGridSubset(gridsetId).getGridSet().getTileWidth();
        int tileHeight = layer.getGridSubset(gridsetId).getGridSet().getTileHeight();
        int width = tileWidth * layer.getMetaTilingFactors()[0];
        int height = tileHeight * layer.getMetaTilingFactors()[1];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage image = new BufferedImage(width, height, 2);
        String formatName = ((MimeType)layer.getMimeTypes().get(0)).getInternalName();
        ImageIO.write((RenderedImage)image, formatName, out);
        return out.toByteArray();
    }

    public static WMSLayer createWMSLayer(String format, GridSetBroker gridSetBroker, int metaTileFactorX, int metaTileFactorY, BoundingBox boundingBox) {
        String[] urls = new String[]{"http://localhost:38080/wms"};
        List<String> formatList = Collections.singletonList(format);
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>();
        GridSubset grid = GridSubsetFactory.createGridSubSet((GridSet)gridSetBroker.getWorldEpsg4326(), (BoundingBox)boundingBox, (Integer)0, (Integer)10);
        grids.put(grid.getName(), grid);
        int[] metaWidthHeight = new int[]{metaTileFactorX, metaTileFactorY};
        WMSLayer layer = new WMSLayer("test:layer", urls, "aStyle", "test:layer", formatList, grids, null, metaWidthHeight, "vendorparam=true", false, null);
        layer.initialize(gridSetBroker);
        return layer;
    }

    public static WMSLayer createWMSLayer(String format, GridSetBroker gridSetBroker) {
        BoundingBox boundingBox = new BoundingBox(-30.0, 15.0, 45.0, 30.0);
        return TestUtils.createWMSLayer(format, gridSetBroker, 3, 3, boundingBox);
    }

    public static String toStr(long[][] array) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append(Arrays.toString(array[i]));
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.append("]").toString();
    }

    public static void assertEquals(long[][] expected, long[][] actual) {
        String errstr = "expected: " + TestUtils.toStr(expected) + ", actual: " + TestUtils.toStr(actual);
        if (expected.length != actual.length) {
            Assert.fail((String)errstr);
        }
        int len = expected.length;
        for (int i = 0; i < len; ++i) {
            if (Arrays.equals(expected[i], actual[i])) continue;
            Assert.fail((String)("At index " + i + ": " + errstr));
        }
    }

    public static void assertEquals(long[] expected, long[] actual) {
        String errstr = "expected: " + Arrays.toString(expected) + ", actual: " + Arrays.toString(actual);
        if (expected.length != actual.length) {
            Assert.fail((String)errstr);
        }
        if (!Arrays.equals(expected, actual)) {
            Assert.fail((String)errstr);
        }
    }

    public static <T> Matcher<Optional<T>> notPresent() {
        return Matchers.hasProperty((String)"present", (Matcher)Matchers.is((Object)false));
    }

    public static <T> Matcher<Optional<T>> isPresent(final Matcher<T> valueMatcher) {
        return new BaseMatcher<Optional<T>>(){

            public boolean matches(Object item) {
                if (!(item instanceof Optional)) {
                    return false;
                }
                return ((Optional)item).map(arg_0 -> ((Matcher)valueMatcher).matches(arg_0)).orElse(false);
            }

            public void describeTo(Description description) {
                description.appendText("Optional with value ").appendDescriptionOf((SelfDescribing)valueMatcher);
            }

            public void describeMismatch(Object item, Description description) {
                if (!(item instanceof Optional)) {
                    description.appendText(item.toString() + " is not an Optional");
                } else if (!((Optional)item).isPresent()) {
                    description.appendText("Value was not present");
                } else {
                    valueMatcher.describeMismatch(((Optional)item).get(), description);
                }
            }
        };
    }

    public static <T> Matcher<Optional<T>> isPresent() {
        return Matchers.hasProperty((String)"present", (Matcher)Matchers.is((Object)true));
    }

    public static Matcher<String> matchesRegex(String regex) {
        final Pattern p = Pattern.compile(regex);
        return new CustomMatcher<String>("matching /" + regex + "/"){

            public boolean matches(Object arg0) {
                return p.matcher((CharSequence)arg0).matches();
            }
        };
    }

    public static <T> T assertPresent(Optional<T> opt) throws AssertionError {
        return opt.orElseThrow(() -> new AssertionError((Object)"Optional was not present"));
    }

    public static <T> T requirePresent(Optional<T> opt) throws IllegalStateException {
        return opt.orElseThrow(() -> new IllegalStateException("Optional was not present and is required for test"));
    }
}

