/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.ArrayList;
import java.util.List;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.mime.FormatModifier;

public class GeoWebCacheConfiguration {
    private String xmlns_xsi;
    private String xsi_schemaLocation;
    private String xmlns;
    private String version;
    private Integer backendTimeout;
    private String lockProvider;
    private transient LockProvider lockProviderInstance;
    private Boolean cacheBypassAllowed;
    private Boolean runtimeStats;
    private String httpUsername;
    private String httpPassword;
    private String proxyUrl;
    private ServiceInformation serviceInformation;
    private List<FormatModifier> formatModifiers;
    private List<BlobStoreInfo> blobStores;
    private List<XMLGridSet> gridSets;
    private Boolean fullWMS;
    private Boolean wmtsCiteCompliant;
    private List<TileLayer> layers;

    public GeoWebCacheConfiguration() {
        this.readResolve();
    }

    private Object readResolve() {
        if (this.version == null) {
            this.setVersion("1.3.0");
        }
        this.xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
        this.xmlns = "http://geowebcache.org/schema/" + this.getVersion();
        this.xsi_schemaLocation = this.xmlns + " http://geowebcache.org/schema/" + this.getVersion() + "/geowebcache.xsd";
        if (this.layers == null) {
            this.layers = new ArrayList<TileLayer>();
        }
        if (this.gridSets == null) {
            this.gridSets = new ArrayList<XMLGridSet>();
        }
        if (this.blobStores == null) {
            this.blobStores = new ArrayList<BlobStoreInfo>();
        }
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.xmlns = "http://geowebcache.org/schema/" + version;
        this.xsi_schemaLocation = this.xmlns + " http://geowebcache.org/schema/" + version + "/geowebcache.xsd";
    }

    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    public void setBackendTimeout(Integer backendTimeout) {
        this.backendTimeout = backendTimeout;
    }

    public Boolean getCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    public void setCacheBypassAllowed(Boolean cacheBypassAllowed) {
        this.cacheBypassAllowed = cacheBypassAllowed;
    }

    public Boolean getRuntimeStats() {
        return this.runtimeStats;
    }

    public void setRuntimeStats(Boolean runtimeStats) {
        this.runtimeStats = runtimeStats;
    }

    public String getHttpUsername() {
        return this.httpUsername;
    }

    public void setHttpUsername(String httpUsername) {
        this.httpUsername = httpUsername;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void setServiceInformation(ServiceInformation serviceInformation) {
        this.serviceInformation = serviceInformation;
    }

    public List<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        this.formatModifiers = formatModifiers;
    }

    public List<BlobStoreInfo> getBlobStores() {
        return this.blobStores;
    }

    public List<XMLGridSet> getGridSets() {
        return this.gridSets;
    }

    public List<TileLayer> getLayers() {
        return this.layers;
    }

    public LockProvider getLockProvider() {
        if (this.lockProviderInstance == null) {
            if (this.lockProvider == null) {
                this.lockProviderInstance = new MemoryLockProvider();
            } else {
                Object provider = GeoWebCacheExtensions.bean(this.lockProvider);
                if (provider == null) {
                    throw new RuntimeException("Could not find lock provider " + this.lockProvider + " in the spring application context");
                }
                if (!(provider instanceof LockProvider)) {
                    throw new RuntimeException("Found bean " + this.lockProvider + " in the spring application context, but it was not a LockProvider");
                }
                this.lockProviderInstance = (LockProvider)provider;
            }
        }
        return this.lockProviderInstance;
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProviderInstance = lockProvider;
    }

    public Boolean getFullWMS() {
        return this.fullWMS;
    }

    public void setFullWMS(Boolean fullWMS) {
        this.fullWMS = fullWMS;
    }

    public boolean isWmtsCiteCompliant() {
        return this.wmtsCiteCompliant != null ? this.wmtsCiteCompliant : false;
    }

    public void setWmtsCiteCompliant(boolean wmtsCiteCompliant) {
        this.wmtsCiteCompliant = wmtsCiteCompliant;
    }
}

