/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.security;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.security.SecurityFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SecurityDispatcher
implements ApplicationContextAware {
    ApplicationContext applicationContext;

    public Collection<SecurityFilter> getFilters() {
        return GeoWebCacheExtensions.extensions(SecurityFilter.class, this.applicationContext);
    }

    public void checkSecurity(ConveyorTile tile) throws SecurityException, GeoWebCacheException {
        SRS srs;
        BoundingBox bounds;
        TileLayer layer = tile.getLayer();
        GridSubset gridSubset = tile.getGridSubset();
        if (Objects.nonNull(gridSubset)) {
            bounds = gridSubset.boundsFromIndex(tile.getTileIndex());
            srs = gridSubset.getSRS();
        } else {
            bounds = null;
            srs = null;
        }
        this.checkSecurity(layer, bounds, srs);
    }

    public void checkSecurity(TileLayer layer, @Nullable BoundingBox extent, @Nullable SRS srs) throws SecurityException, GeoWebCacheException {
        if (Objects.isNull(extent) != Objects.isNull(srs)) {
            throw new NullPointerException("Extent and srs must either both be null or both be non-null");
        }
        for (SecurityFilter filter : this.getFilters()) {
            filter.checkSecurity(layer, extent, srs);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean isSecurityEnabled() {
        return !this.getFilters().isEmpty();
    }
}

